package ru.yandex.direct.liveresource;

import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Обертка над {@link LiveResource}, кеширующая содержимое. Может использоваться как {@link LiveResourceListener}, для
 * обновления содержимого, например, с помощью {@link PollingLiveResourceWatcher}
 */
@ParametersAreNonnullByDefault
public class CachingLiveResource implements LiveResource, LiveResourceListener {

    private LiveResource liveResource;
    private AtomicReference<String> content;

    public CachingLiveResource(LiveResource liveResource) {
        this.liveResource = liveResource;
        this.content = new AtomicReference<>(liveResource.getContent());
    }

    @Override
    public void update(LiveResourceEvent event) {
        content.set(event.getCurrentContent());
    }

    @Override
    public String getContent() {
        return content.get();
    }

    @Override
    public String getLocation() {
        return liveResource.getLocation();
    }
}
