package ru.yandex.direct.liveresource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import org.apache.commons.io.IOUtils;

/**
 * Implementation of {@link LiveResource} for read data from classpath resources
 */
public class ClasspathLiveResource implements LiveResource {
    private final String location;

    /**
     * Create a new ClasspathLiveResource
     *
     * @param location - path to resource in classpath
     */
    public ClasspathLiveResource(String location) {
        this.location = location;
    }

    /**
     * Read data from resource in classpath
     *
     * @return - text content of resource
     */
    @Override
    public String getContent() {
        try (InputStream stream = ClasspathLiveResource.class.getResourceAsStream(this.location)) {
            if (stream == null) {
                throw new LiveResourceReadException("Can't find classpath resource " + location);
            }
            return IOUtils.toString(stream, StandardCharsets.UTF_8);
        } catch (IOException ex) {
            throw new LiveResourceReadException("Can't read classpath resource " + location, ex);
        }
    }

    @Override
    public String getLocation() {
        return location;
    }
}
