package ru.yandex.direct.liveresource;

import java.nio.file.Path;

import ru.yandex.direct.utils.io.FileUtils;
import ru.yandex.direct.utils.io.RuntimeIoException;

/**
 * Implementation of {@link LiveResource} for read data from file
 */
public class FileLiveResource implements LiveResource {
    private final Path filePath;

    /**
     * Create a new FileLiveResource
     *
     * @param filePath
     */
    public FileLiveResource(Path filePath) {
        this.filePath = filePath;
    }

    /**
     * Read data from file
     *
     * @return - text content of file
     */
    @Override
    public String getContent() {
        try {
            return FileUtils.slurp(filePath);
        } catch (RuntimeIoException e) {
            throw new LiveResourceReadException("Cannot read file " + filePath, e);
        }
    }

    @Override
    public String getLocation() {
        return filePath.toString();
    }
}
