package ru.yandex.direct.liveresource;

/**
 * Object, capable of watching for LiveResource changes and notifying registered listeners
 */
public interface LiveResourceWatcher {

    /**
     * Starts watching for resource
     * @return initial LiveResource value
     */
    String watch();

    /**
     * @return LiveResource being watched by watcher
     */
    LiveResource getLiveResource();

    /**
     * Adds listener to be notified of LiveResource changes
     */
    void addListener(LiveResourceListener listener);

    /**
     * Stop watching and release resources
     */
    default void close() {}
}
