package ru.yandex.direct.liveresource;

import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

import static ru.yandex.direct.config.EssentialConfiguration.CONFIG_SCHEDULER_BEAN_NAME;

@Component
public class LiveResourceWatcherFactory {

    public static final long DEFAULT_POLLING_CHECK_RATE = TimeUnit.SECONDS.toMillis(10); // 10 seconds

    private final TaskScheduler defaultTaskScheduler;

    public LiveResourceWatcherFactory(@Qualifier(CONFIG_SCHEDULER_BEAN_NAME) TaskScheduler defaultTaskScheduler) {
        this.defaultTaskScheduler = defaultTaskScheduler;
    }

    public LiveResourceWatcher createWatcher(LiveResource liveResource) {
        return createWatcher(liveResource, defaultTaskScheduler);
    }

    public LiveResourceWatcher createWatcher(LiveResource liveResource, TaskScheduler taskScheduler) {
        if (liveResource instanceof WatchableLiveResource) {
            return ((WatchableLiveResource) liveResource).createWatcher(taskScheduler);
        } else {
            return createPollingWatcher(liveResource, taskScheduler, DEFAULT_POLLING_CHECK_RATE);
        }
    }

    public LiveResourceWatcher createPollingWatcher(LiveResource liveResource, TaskScheduler taskScheduler, long checkRateMillis) {
        return new PollingLiveResourceWatcher(liveResource, liveResource.getContent(), taskScheduler, checkRateMillis);
    }

}
