package ru.yandex.direct.liveresource;

/**
 * Implementation of {@link LiveResource} for read data from file
 */
public class MemoryLiveResource implements LiveResource {
    private static final String MEMORY_LOCATION = "Memory location";
    private final String content;

    /**
     * Create a new MemoryLiveResource
     *
     * @param content
     */
    public MemoryLiveResource(String content) {
        this.content = content;
    }

    @Override
    public String getContent() {
        return content;
    }

    @Override
    public String getLocation() {
        return MEMORY_LOCATION;
    }
}
