package ru.yandex.direct.liveresource.provider;

import java.net.URI;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.direct.liveresource.ClasspathLiveResource;
import ru.yandex.direct.liveresource.LiveResource;

@Component
public class ClasspathLiveResourceProvider implements LiveResourceProvider {

    @Nonnull
    @Override
    public String getScheme() {
        return "classpath";
    }

    @Override
    public LiveResource get(URI uri) {
        return new ClasspathLiveResource(uri.getPath());
    }
}
