package ru.yandex.direct.liveresource.provider;

import java.net.URI;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.direct.liveresource.FileLiveResource;
import ru.yandex.direct.liveresource.LiveResource;
import ru.yandex.direct.utils.io.FileUtils;

@Component
public class FileLiveResourceProvider implements LiveResourceProvider {

    @Nonnull
    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public LiveResource get(URI uri) {
        String path = (uri.getAuthority() != null ? uri.getAuthority() : "") + uri.getPath();
        return new FileLiveResource(FileUtils.expandHome(path));
    }
}
