package ru.yandex.direct.liveresource.provider;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.liveresource.LiveResource;
import ru.yandex.direct.liveresource.MemoryLiveResource;

@Component
public class LiveResourceFactoryBean {

    public static final String MEMORY_RESOURCE_SCHEME = "memory://";

    private List<LiveResourceProvider> providers;

    @Autowired
    public LiveResourceFactoryBean(List<LiveResourceProvider> providers) {
        this.providers = providers;
    }

    public LiveResource get(@Nonnull String resource) {
        Objects.requireNonNull(resource);

        if (resource.startsWith(MEMORY_RESOURCE_SCHEME)) {
            return new MemoryLiveResource(resource.replaceFirst(MEMORY_RESOURCE_SCHEME, ""));
        }

        try {
            URI uri = new URI(resource);
            for (var provider : providers) {
                if (provider.getScheme().equals(uri.getScheme())) {
                    return provider.get(uri);
                }
            }

            throw new IllegalArgumentException("Unknown live resource scheme: " + resource);
        } catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect resource URI: " + resource, e);
        }
    }
}
