package ru.yandex.direct.logging;


import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Глобальный MDC, куда можно устанавливать значения, а потом использовать как фолбэк в CustomMdcPatternConverter
 */
public class GlobalCustomMdc {
    private static final Map<String, String> MAP = new ConcurrentHashMap<>();

    private GlobalCustomMdc() {
    }

    /**
     * Установить значение для ключа в контексте
     */
    public static void put(String key, String value) {
        MAP.put(key, value);
    }

    /**
     * Установить все значения из Map в контекст
     */
    public static void putAll(Map<String, String> ctx) {
        MAP.putAll(ctx);
    }

    /**
     * Получить значение из контекста
     */
    public static String getValue(String key) {
        return MAP.get(key);
    }

}
