package ru.yandex.direct.logging;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

import ru.yandex.direct.utils.SystemUtils;

@Plugin(name = "HostnamePatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({HostnamePatternConverter.PRIMARY_KEY})
public class HostnamePatternConverter extends LogEventPatternConverter {
    public static final String PRIMARY_KEY = "CUSTOMHOSTNAME";
    private final String value;

    public HostnamePatternConverter(String[] options, String value) {
        super(options != null && options.length > 0 ?
                String.format("%s{%s}", PRIMARY_KEY, options[0]) :
                PRIMARY_KEY, "hostname");
        this.value = value;
    }

    public static PatternConverter newInstance(final String[] options) {
        return new HostnamePatternConverter(options, SystemUtils.hostname());
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(value);
    }
}
