package ru.yandex.direct.logging;

import com.beust.jcommander.Parameter;

/**
 * Инкапсулирует параметры командной строки, влияющие на логирующую подсистему.
 * Предназначен для удобной передачи параметров из main в
 * {@link LoggingInitializer#initialize(LoggingInitializerParams)}
 */
public class LoggingInitializerParams {
    private String log4jConfigDirectory;

    @Parameter(
            names = {"-l", "--log-configs-directory"},
            description = "logging configs root directory"
    )
    public void setConfigsDirectory(String configsDirectory) {
        this.log4jConfigDirectory = configsDirectory;
    }

    /**
     * @return каталог, где нужно искать конфиги логирующей подсистемы
     */
    public String getConfigsDirectory() {
        return log4jConfigDirectory;
    }
}
