package ru.yandex.direct.logging;

public class LoggingInitializerUtils {

    /**
     * По умолчанию запрещаем инициализировать конфигурацию log4j2 несколько раз
     */
    private static boolean allowReinitialization = false;

    /**
     * Позволяет использовать {@link LoggingInitializer} после инициализации логгирования. По умолчанию запрещено,
     * чтобы обнаруживать проблемы с некорректной инициализацией
     */
    public static void allowReinitialization() {
        allowReinitialization = true;
    }

    public static boolean isReinitializationAllowed() {
        return allowReinitialization;
    }

    private LoggingInitializerUtils() {
    }

}
