package ru.yandex.direct.logging;

import java.util.HashMap;
import java.util.Map;

import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;

import ru.yandex.logbroker.agent.log4j2.appender.UnifiedAgentAppender;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

public class UnifiedAgentLog4jUtils {
    /**
     * Ищет в текущей конфигурации log4j аппендеры UnifiedAgentAppender, собирает из них наборы метрик
     * И возвращает мапу appenderName → metricRegistry
     */
    public static Map<String, MetricRegistry> getUnifiedAgentLog4jMetrics() {
        Map<String, Appender> appenders = LoggerContext.getContext(false).getConfiguration().getAppenders();
        Map<String, MetricRegistry> metricRegistries = new HashMap<>();
        for (var entry : appenders.entrySet()) {
            String name = entry.getKey();
            Appender appender = entry.getValue();
            if (appender instanceof UnifiedAgentAppender) {
                MetricRegistry metrics = ((UnifiedAgentAppender) appender).getMetricRegistry();
                if (metrics != null) {
                    metricRegistries.put(name, metrics);
                }
            }
        }
        return metricRegistries;
    }
}
