package ru.yandex.direct.version;

import ru.yandex.direct.utils.JsonUtils;

/**
 * Используется утилитой dt-java-hotfix для получения ревизии репозитория из которой собран пакет с приложением
 */
public class GetDirectVersionTool {

    public static void main(String[] args) {
        VersionInfo versionInfo = new VersionInfo(
                DirectVersion.getMajorVersion(),
                DirectVersion.getMinorVersion(),
                DirectVersion.getVcsVersion().getArcadiaSourceUrl(),
                DirectVersion.getVcsVersion().getBranch(),
                DirectVersion.getVcsVersion().getArcadiaLastChangeNum()
        );
        System.out.println(JsonUtils.toJson(versionInfo));
    }

    private static class VersionInfo {
        private int major;
        private int minor;
        private String sourceUrl;
        private String branch;
        private int lastChange;

        public VersionInfo(int major, int minor, String sourceUrl, String branch, int lastChange) {
            this.major = major;
            this.minor = minor;
            this.sourceUrl = sourceUrl;
            this.branch = branch;
            this.lastChange = lastChange;
        }

        public int getMajor() {
            return major;
        }

        public int getMinor() {
            return minor;
        }

        public String getSourceUrl() {
            return sourceUrl;
        }

        public String getBranch() {
            return branch;
        }

        public int getLastChange() {
            return lastChange;
        }
    }
}
