package ru.yandex.direct.core.entity.campaign.model;

import java.util.regex.Pattern;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CampaignMeasurerParamsIas {
    private static final Pattern IAS_MEASURE_PARAMS_PATTERN = Pattern.compile("https://pixel.adsafeprotected.com/rfw/st/" +
            "(?<advid>\\d+)/(?<pubid>\\d+)/skeleton.gif");

    private static final String IAS_MEASURE_PARAMS_TEMPLATE = "https://pixel.adsafeprotected.com/rfw/st/%d/%d/skeleton.gif";

    @JsonProperty("advid")
    private Long advid;

    @JsonProperty("pubid")
    private Long pubid;

    public static CampaignMeasurerParamsIas from(String rawParams) {
        var match = IAS_MEASURE_PARAMS_PATTERN.matcher(rawParams);
        var params = new CampaignMeasurerParamsIas();
        if (match.find()) {
            params.setAdvid(Long.parseLong(match.group("advid")));
            params.setPubid(Long.parseLong(match.group("pubid")));
        }
        return params;
    }

    public String toGd() {
        return String.format(IAS_MEASURE_PARAMS_TEMPLATE, getAdvid(), getPubid());
    }

    public Long getAdvid() {
        return advid;
    }

    public void setAdvid(Long advid) {
        this.advid = advid;
    }

    public Long getPubid() {
        return pubid;
    }

    public void setPubid(Long pubid) {
        this.pubid = pubid;
    }

}
