package ru.yandex.direct.core.entity.campaign.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DbStrategy extends DbStrategyBase {

    private static Set<StrategyName> cpaStrategies = new HashSet<>(Arrays.asList(
            StrategyName.AUTOBUDGET_AVG_CPA,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER));
    private static Set<CampOptionsStrategy> cpaOptionsStrategies = new HashSet<>(Arrays.asList(
            CampOptionsStrategy.AUTOBUDGET_AVG_CPA_PER_CAMP,
            CampOptionsStrategy.AUTOBUDGET_AVG_CPA_PER_FILTER));
    private static Set<StrategyName> cpcStrategies = new HashSet<>(Arrays.asList(
            StrategyName.AUTOBUDGET_AVG_CLICK,
            StrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP,
            StrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER));
    private static Set<CampOptionsStrategy> cpcOptionsStrategies = new HashSet<>(Arrays.asList(
            CampOptionsStrategy.AUTOBUDGET_AVG_CPC_PER_CAMP,
            CampOptionsStrategy.AUTOBUDGET_AVG_CPC_PER_FILTER));

    public boolean isAutoBudget() {
        return getAutobudget() == CampaignsAutobudget.YES;
    }

    /**
     * @return {@code true}, если включены показы на поиске
     */
    public boolean isSearchStrategy() {
        return getPlatform() == CampaignsPlatform.SEARCH ||
                getPlatform() == CampaignsPlatform.BOTH;
    }

    /**
     * @return {@code true}, если выключены показы на поиске
     */
    public boolean isSearchStop() {
        return !isSearchStrategy();
    }

    /**
     * @return {@code true}, если включены показы в сетях
     */
    public boolean isNetStrategy() {
        return getPlatform() == CampaignsPlatform.CONTEXT ||
                getPlatform() == CampaignsPlatform.BOTH;
    }

    /**
     * @return {@code true}, если выключены показы в сетях
     */
    public boolean isNetStop() {
        return !isNetStrategy();
    }

    /**
     * Довольно неоднозначный флаг сам по себе.
     * Стратегия считается "different places", если
     * <ul>
     * <li>Стратегия ручная, включены показы на поиске и в сетях, и есть раздельное управление ставками</li>
     * <li>Стратегия ручная, с показами только в сетях</li>
     * <li>Стратегия автоматическая, с показами только в сетях</li>
     * </ul>
     */
    public boolean isDifferentPlaces() {
        return getStrategy() == CampOptionsStrategy.DIFFERENT_PLACES;
    }

    /**
     * @return управляются ли ставки на поиске вручную
     */
    public boolean isSearchManualBidManaging() {
        return !isAutoBudget() && isSearchStrategy();
    }

    /**
     * Функция определяет, управляются ли ставки в сети вручную.
     * Это происходит, когда стратегия не автоматическая, и показы включены либо только в сетях,
     * либо на обеих площадках со включенным раздельным управлением ставками
     *
     * @return управляются ли ставки в сети вручную
     */
    public boolean isContextManualBidManaging() {
        return !isAutoBudget() && isNetStrategy() && (
                isSearchStop() || isSearchStrategy() && isDifferentPlaces()
        );
    }

    public boolean isCpa() {
        return cpaStrategies.contains(getStrategyName()) || cpaOptionsStrategies.contains(getStrategy());
    }

    public boolean isCpc() {
        return cpcStrategies.contains(getStrategyName()) || cpcOptionsStrategies.contains(getStrategy());
    }

    public boolean isCpm() {
        return getStrategyName() == StrategyName.CPM_DEFAULT;
    }

    public boolean isAvgCpi() {
        return getStrategyName() == StrategyName.AUTOBUDGET_AVG_CPI;
    }

    @Override
    public DbStrategy copy() {
        final var target = new DbStrategy();
        return (DbStrategy) super.copyTo(target);
    }
}
