package ru.yandex.direct.core.entity.campaign.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.utils.NumberUtils;

import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Код перла по стратегиям: https://svn.yandex-team.ru/websvn/wsvn/direct/trunk/protected/Direct/Strategy
 * Однострочник для получения списка всех доступных полей в перловых моделях:
 * grep -R "^has.*'rw'" protected/Direct/Strategy | awk -F: '{ print $2 }' | awk '{ print $2 }' | sort -u
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class StrategyData implements Model {

    private static final Logger logger = LoggerFactory.getLogger(StrategyData.class);

    public static final ModelProperty<StrategyData, String> NAME =
            ModelProperty.create(StrategyData.class, "name", StrategyData::getName, StrategyData::setName);

    public static final ModelProperty<StrategyData, BigDecimal> AVG_BID =
            ModelProperty.create(StrategyData.class, "avgBid", StrategyData::getAvgBid, StrategyData::setAvgBid);

    public static final ModelProperty<StrategyData, BigDecimal> AVG_CPA =
            ModelProperty.create(StrategyData.class, "avgCpa", StrategyData::getAvgCpa, StrategyData::setAvgCpa);

    public static final ModelProperty<StrategyData, BigDecimal> AVG_CPV =
            ModelProperty.create(StrategyData.class, "avgCpv", StrategyData::getAvgCpv, StrategyData::setAvgCpv);

    public static final ModelProperty<StrategyData, Boolean> PAY_FOR_CONVERSION =
            ModelProperty.create(StrategyData.class, "payForConversion", StrategyData::getPayForConversion,
                    StrategyData::setPayForConversion);

    public static final ModelProperty<StrategyData, BigDecimal> AVG_CPI =
            ModelProperty.create(StrategyData.class, "avgCpi", StrategyData::getAvgCpi, StrategyData::setAvgCpi);

    public static final ModelProperty<StrategyData, BigDecimal> AVG_CPM =
            ModelProperty.create(StrategyData.class, "avgCpm", StrategyData::getAvgCpm, StrategyData::setAvgCpm);

    public static final ModelProperty<StrategyData, BigDecimal> FILTER_AVG_BID =
            ModelProperty.create(StrategyData.class, "filterAvgBid", StrategyData::getFilterAvgBid,
                    StrategyData::setFilterAvgBid);

    public static final ModelProperty<StrategyData, BigDecimal> FILTER_AVG_CPA =
            ModelProperty.create(StrategyData.class, "filterAvgCpa", StrategyData::getFilterAvgCpa,
                    StrategyData::setFilterAvgCpa);

    public static final ModelProperty<StrategyData, BigDecimal> BID =
            ModelProperty.create(StrategyData.class, "bid", StrategyData::getBid, StrategyData::setBid);

    public static final ModelProperty<StrategyData, BigDecimal> SUM =
            ModelProperty.create(StrategyData.class, "sum", StrategyData::getSum, StrategyData::setSum);

    public static final ModelProperty<StrategyData, BigDecimal> BUDGET =
            ModelProperty.create(StrategyData.class, "budget", StrategyData::getBudget, StrategyData::setBudget);

    public static final ModelProperty<StrategyData, Long> CRR =
            ModelProperty.create(StrategyData.class, "crr", StrategyData::getCrr, StrategyData::setCrr);

    public static final ModelProperty<StrategyData, Long> GOAL_ID =
            ModelProperty.create(StrategyData.class, "goalId", StrategyData::getGoalId, StrategyData::setGoalId);

    public static final ModelProperty<StrategyData, BigDecimal> ROI_COEF =
            ModelProperty.create(StrategyData.class, "roiCoef", StrategyData::getRoiCoef, StrategyData::setRoiCoef);

    public static final ModelProperty<StrategyData, BigDecimal> PROFITABILITY =
            ModelProperty.create(StrategyData.class, "profitability", StrategyData::getProfitability,
                    StrategyData::setProfitability);

    public static final ModelProperty<StrategyData, Long> RESERVE_RETURN =
            ModelProperty.create(StrategyData.class, "reserveReturn", StrategyData::getReserveReturn,
                    StrategyData::setReserveReturn);

    public static final ModelProperty<StrategyData, BigDecimal> RF_DECAY =
            ModelProperty.create(StrategyData.class, "rfDecay", StrategyData::getRfDecay,
                    StrategyData::setRfDecay);

    public static final ModelProperty<StrategyData, BigDecimal> RF_MIN_CPM =
            ModelProperty.create(StrategyData.class, "rfMinCpm", StrategyData::getRfMinCpm,
                    StrategyData::setRfMinCpm);

    public static final ModelProperty<StrategyData, Long> LIMIT_CLICKS =
            ModelProperty.create(StrategyData.class, "limitClicks", StrategyData::getLimitClicks,
                    StrategyData::setLimitClicks);

    public static final ModelProperty<StrategyData, StrategyPlace> PLACE =
            ModelProperty.create(StrategyData.class, "place", StrategyData::getPlace, StrategyData::setPlace);

    public static final ModelProperty<StrategyData, LocalDate> START =
            ModelProperty.create(StrategyData.class, "start", StrategyData::getStart, StrategyData::setStart);

    public static final ModelProperty<StrategyData, LocalDate> FINISH =
            ModelProperty.create(StrategyData.class, "finish", StrategyData::getFinish, StrategyData::setFinish);

    public static final ModelProperty<StrategyData, LocalDate> DATE =
            ModelProperty.create(StrategyData.class, "date", StrategyData::getDate, StrategyData::setDate);

    public static final ModelProperty<StrategyData, Long> DAILY_CHANGE_COUNT =
            ModelProperty.create(StrategyData.class, "dailyChangeCount", StrategyData::getDailyChangeCount,
                    StrategyData::setDailyChangeCount);

    public static final ModelProperty<StrategyData, Long> VERSION =
            ModelProperty.create(StrategyData.class, "version", StrategyData::getVersion, StrategyData::setVersion);

    public static final ModelProperty<StrategyData, LocalDateTime> LAST_BIDDER_RESTART_TIME =
            ModelProperty.create(StrategyData.class, "lastBidderRestartTime", StrategyData::getLastBidderRestartTime,
                    StrategyData::setLastBidderRestartTime);

    private String name;

    @JsonProperty("avg_bid")
    private BigDecimal avgBid;

    @JsonProperty("avg_cpa")
    private BigDecimal avgCpa;

    @JsonProperty("avg_cpv")
    private BigDecimal avgCpv;

    @JsonProperty("avg_cpi")
    private BigDecimal avgCpi;

    @JsonProperty("avg_cpm")
    private BigDecimal avgCpm;

    @JsonProperty("filter_avg_bid")
    private BigDecimal filterAvgBid;

    @JsonProperty("filter_avg_cpa")
    private BigDecimal filterAvgCpa;

    private BigDecimal bid;

    private BigDecimal sum;

    private BigDecimal budget;

    private Long crr;

    @JsonProperty("goal_id")
    private Long goalId;

    @JsonProperty("roi_coef")
    private BigDecimal roiCoef;

    private BigDecimal profitability;

    @JsonProperty("reserve_return")
    private Long reserveReturn;

    @JsonProperty("rf_decay")
    private BigDecimal rfDecay;

    @JsonProperty("rf_min_cpm")
    private BigDecimal rfMinCpm;

    @JsonProperty("limit_clicks")
    private Long limitClicks;

    private StrategyPlace place;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate date;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate start;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate finish;

    private Long version;

    @JsonProperty("last_update_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastUpdateTime;

    @JsonProperty("daily_change_count")
    private Long dailyChangeCount;

    @JsonProperty("auto_prolongation")
    private Long autoProlongation;

    @JsonProperty("pay_for_conversion")
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    private Boolean payForConversion;

    @JsonProperty("last_bidder_restart_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastBidderRestartTime;

    // хранятся все неизвестые поля стратегии, чтобы не затирать их, пока есть перл код
    private Map<String, Object> unknownFields = new HashMap<>();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StrategyData withName(String name) {
        this.name = name;
        return this;
    }

    public BigDecimal getAvgBid() {
        return avgBid;
    }

    public void setAvgBid(BigDecimal avgBid) {
        this.avgBid = avgBid;
    }

    public StrategyData withAvgBid(BigDecimal avgBid) {
        setAvgBid(avgBid);
        return this;
    }

    public BigDecimal getAvgCpa() {
        return avgCpa;
    }

    public void setAvgCpa(BigDecimal avgCpa) {
        this.avgCpa = avgCpa;
    }

    public StrategyData withAvgCpa(BigDecimal avgCpa) {
        setAvgCpa(avgCpa);
        return this;
    }

    public BigDecimal getAvgCpv() {
        return avgCpv;
    }

    public void setAvgCpv(BigDecimal avgCpv) {
        this.avgCpv = avgCpv;
    }

    public StrategyData withAvgCpv(BigDecimal avgCpv) {
        setAvgCpv(avgCpv);
        return this;
    }

    public BigDecimal getAvgCpi() {
        return avgCpi;
    }

    public void setAvgCpi(BigDecimal avgCpi) {
        this.avgCpi = avgCpi;
    }

    public StrategyData withAvgCpi(BigDecimal avgCpi) {
        setAvgCpi(avgCpi);
        return this;
    }

    public BigDecimal getAvgCpm() {
        return avgCpm;
    }

    public void setAvgCpm(BigDecimal avgCpm) {
        this.avgCpm = avgCpm;
    }

    public StrategyData withAvgCpm(BigDecimal avgCpi) {
        setAvgCpm(avgCpi);
        return this;
    }

    public BigDecimal getFilterAvgBid() {
        return filterAvgBid;
    }

    public void setFilterAvgBid(BigDecimal filterAvgBid) {
        this.filterAvgBid = filterAvgBid;
    }

    public StrategyData withFilterAvgBid(BigDecimal filterAvgBid) {
        setFilterAvgBid(filterAvgBid);
        return this;
    }

    public BigDecimal getFilterAvgCpa() {
        return filterAvgCpa;
    }

    public void setFilterAvgCpa(BigDecimal filterAvgCpa) {
        this.filterAvgCpa = filterAvgCpa;
    }

    public StrategyData withFilterAvgCpa(BigDecimal filterAvgCpa) {
        setFilterAvgCpa(filterAvgCpa);
        return this;
    }

    public BigDecimal getBid() {
        return bid;
    }

    public void setBid(BigDecimal bid) {
        this.bid = bid;
    }

    public StrategyData withBid(BigDecimal bid) {
        setBid(bid);
        return this;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public StrategyData withSum(BigDecimal sum) {
        setSum(sum);
        return this;
    }

    public Long getCrr() {
        return crr;
    }

    public void setCrr(Long crr) {
        this.crr = crr;
    }

    public StrategyData withCrr(Long crr) {
        setCrr(crr);
        return this;
    }

    public Long getGoalId() {
        return goalId;
    }

    public void setGoalId(Long goalId) {
        this.goalId = goalId;
    }

    public StrategyData withGoalId(Long goalId) {
        setGoalId(goalId);
        return this;
    }

    public BigDecimal getRoiCoef() {
        return roiCoef;
    }

    public void setRoiCoef(BigDecimal roiCoef) {
        this.roiCoef = roiCoef;
    }

    public StrategyData withRoiCoef(BigDecimal roiCoef) {
        setRoiCoef(roiCoef);
        return this;
    }

    public BigDecimal getProfitability() {
        return profitability;
    }

    public void setProfitability(BigDecimal profitability) {
        this.profitability = profitability;
    }

    public StrategyData withProfitability(BigDecimal profitability) {
        setProfitability(profitability);
        return this;
    }

    public Long getReserveReturn() {
        return reserveReturn;
    }

    public void setReserveReturn(Long reserveReturn) {
        this.reserveReturn = reserveReturn;
    }

    public StrategyData withReserveReturn(Long reserveReturn) {
        setReserveReturn(reserveReturn);
        return this;
    }

    public BigDecimal getRfDecay() {
        return rfDecay;
    }

    public void setRfDecay(BigDecimal rfDecay) {
        this.rfDecay = rfDecay;
    }

    public StrategyData withRfDecay(BigDecimal rfDecay) {
        this.rfDecay = rfDecay;
        return this;
    }

    public BigDecimal getRfMinCpm() {
        return rfMinCpm;
    }

    public void setRfMinCpm(BigDecimal rfMinCpm) {
        this.rfMinCpm = rfMinCpm;
    }

    public StrategyData withRfMinCpm(BigDecimal rfMinCpm) {
        this.rfMinCpm = rfMinCpm;
        return this;
    }

    public Long getLimitClicks() {
        return limitClicks;
    }

    public void setLimitClicks(Long limitClicks) {
        this.limitClicks = limitClicks;
    }

    public StrategyData withLimitClicks(Long limitClicks) {
        setLimitClicks(limitClicks);
        return this;
    }

    public StrategyPlace getPlace() {
        return place;
    }

    public void setPlace(StrategyPlace place) {
        this.place = place;
    }

    public StrategyData withPlace(StrategyPlace place) {
        setPlace(place);
        return this;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public StrategyData withDate(LocalDate date) {
        setDate(date);
        return this;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public StrategyData withVersion(Long version) {
        setVersion(version);
        return this;
    }

    public BigDecimal getBudget() {
        return budget;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    public StrategyData withBudget(BigDecimal budget) {
        setBudget(budget);
        return this;
    }

    public LocalDate getStart() {
        return start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
    }

    public StrategyData withStart(LocalDate start) {
        setStart(start);
        return this;
    }

    public LocalDate getFinish() {
        return finish;
    }

    public void setFinish(LocalDate finish) {
        this.finish = finish;
    }

    public StrategyData withFinish(LocalDate finish) {
        setFinish(finish);
        return this;
    }

    public Long getAutoProlongation() {
        return autoProlongation;
    }

    public void setAutoProlongation(Long autoProlongation) {
        this.autoProlongation = autoProlongation;
    }

    public StrategyData withAutoProlongation(Long autoProlongation) {
        setAutoProlongation(autoProlongation);
        return this;
    }

    public Boolean getPayForConversion() {
        return payForConversion;
    }

    public void setPayForConversion(Boolean payForConversion) {
        this.payForConversion = payForConversion;
    }

    public StrategyData withPayForConversion(Boolean payForConversion) {
        this.payForConversion = payForConversion;
        return this;
    }

    public LocalDateTime getLastBidderRestartTime() {
        return lastBidderRestartTime;
    }

    public void setLastBidderRestartTime(LocalDateTime lastBidderRestartTime) {
        this.lastBidderRestartTime = lastBidderRestartTime;
    }

    public StrategyData withLastBidderRestartTime(LocalDateTime lastBidderRestartTime) {
        this.lastBidderRestartTime = lastBidderRestartTime;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getUnknownFields() {
        return unknownFields;
    }

    @JsonAnySetter
    public void handleUnknownFields(String key, Object value) {
        unknownFields.put(key, value);
        logger.warn("unknown strategy fields: {}", toJson(unknownFields));
    }

    public StrategyData withUnknownFields(Map<String, Object> unknownFields) {
        this.unknownFields = unknownFields;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.core.entity.campaign.model.StrategyData{");
        sb.append("name=").append(name);
        sb.append(", avgBid=").append(avgBid);
        sb.append(", avgCpa=").append(avgCpa);
        sb.append(", avgCpv=").append(avgCpv);
        sb.append(", avgCpi=").append(avgCpi);
        sb.append(", avgCpm=").append(avgCpm);
        sb.append(", budget=").append(budget);
        sb.append(", start=").append(start);
        sb.append(", finish=").append(finish);
        sb.append(", autoProlongation=").append(autoProlongation);
        sb.append(", filterAvgBid=").append(filterAvgBid);
        sb.append(", filterAvgCpa=").append(filterAvgCpa);
        sb.append(", bid=").append(bid);
        sb.append(", sum=").append(sum);
        sb.append(", goalId=").append(goalId);
        sb.append(", payForConversion=").append(payForConversion);
        sb.append(", crr=").append(crr);
        sb.append(", roiCoef=").append(roiCoef);
        sb.append(", rfDecay=").append(rfDecay);
        sb.append(", rfMinCpm=").append(rfMinCpm);
        sb.append(", profitability=").append(profitability);
        sb.append(", reserveReturn=").append(reserveReturn);
        sb.append(", limitClicks=").append(limitClicks);
        sb.append(", place=").append(place);
        sb.append(", date=").append(date);
        sb.append(", version=").append(version);
        sb.append(", payForConversion=").append(version);
        sb.append(", unknownFields=").append(unknownFields);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StrategyData that = (StrategyData) o;
        return Objects.equals(name, that.name)
                && NumberUtils.equalsByCompareTo(avgBid, that.avgBid)
                && NumberUtils.equalsByCompareTo(avgCpa, that.avgCpa)
                && NumberUtils.equalsByCompareTo(avgCpv, that.avgCpv)
                && NumberUtils.equalsByCompareTo(avgCpi, that.avgCpi)
                && NumberUtils.equalsByCompareTo(avgCpm, that.avgCpm)
                && NumberUtils.equalsByCompareTo(budget, that.budget)
                && Objects.equals(start, that.start)
                && Objects.equals(finish, that.finish)
                && Objects.equals(autoProlongation, that.autoProlongation)
                && Objects.equals(payForConversion, that.payForConversion)
                && NumberUtils.equalsByCompareTo(filterAvgBid, that.filterAvgBid)
                && NumberUtils.equalsByCompareTo(filterAvgCpa, that.filterAvgCpa)
                && NumberUtils.equalsByCompareTo(bid, that.bid)
                && NumberUtils.equalsByCompareTo(sum, that.sum)
                && Objects.equals(goalId, that.goalId)
                && Objects.equals(crr, that.crr)
                && NumberUtils.equalsByCompareTo(roiCoef, that.roiCoef)
                && NumberUtils.equalsByCompareTo(rfDecay, that.rfDecay)
                && NumberUtils.equalsByCompareTo(rfMinCpm, that.rfMinCpm)
                && NumberUtils.equalsByCompareTo(profitability, that.profitability)
                && Objects.equals(reserveReturn, that.reserveReturn)
                && Objects.equals(limitClicks, that.limitClicks)
                && Objects.equals(place, that.place)
                && Objects.equals(date, that.date)
                && Objects.equals(version, that.version)
                && Objects.equals(lastUpdateTime, that.lastUpdateTime)
                && Objects.equals(dailyChangeCount, that.dailyChangeCount)
                && Objects.equals(unknownFields, that.unknownFields)
                && Objects.equals(lastBidderRestartTime, that.lastBidderRestartTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                name,
                avgBid,
                avgCpa,
                avgCpv,
                avgCpi,
                avgCpm,
                filterAvgBid,
                filterAvgCpa,
                bid,
                sum,
                goalId,
                crr,
                roiCoef,
                profitability,
                reserveReturn,
                rfDecay,
                rfMinCpm,
                limitClicks,
                place,
                date,
                version,
                payForConversion,
                unknownFields,
                lastBidderRestartTime
        );
    }

    public LocalDateTime getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(LocalDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public StrategyData withLastUpdateTime(LocalDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public Long getDailyChangeCount() {
        return dailyChangeCount;
    }

    public void setDailyChangeCount(Long dailyChangeCount) {
        this.dailyChangeCount = dailyChangeCount;
    }

    public StrategyData withDailyChangeCount(Long dailyChangeCount) {
        this.dailyChangeCount = dailyChangeCount;
        return this;
    }

    protected StrategyData copyTo(final StrategyData target) {
        target.name = this.name;
        target.avgBid = this.avgBid;
        target.avgCpa = this.avgCpa;
        target.avgCpv = this.avgCpv;
        target.avgCpi = this.avgCpi;
        target.avgCpm = this.avgCpm;
        target.filterAvgBid = this.filterAvgBid;
        target.filterAvgCpa = this.filterAvgCpa;
        target.bid = this.bid;
        target.sum = this.sum;
        target.budget = this.budget;
        target.goalId = this.goalId;
        target.crr = this.crr;
        target.roiCoef = this.roiCoef;
        target.profitability = this.profitability;
        target.reserveReturn = this.reserveReturn;
        target.rfDecay = this.rfDecay;
        target.rfMinCpm = this.rfMinCpm;
        target.limitClicks = this.limitClicks;
        target.place = this.place;
        target.date = this.date;
        target.start = this.start;
        target.finish = this.finish;
        target.version = this.version;
        target.lastUpdateTime = this.lastUpdateTime;
        target.dailyChangeCount = this.dailyChangeCount;
        target.autoProlongation = this.autoProlongation;
        target.payForConversion = this.payForConversion;
        target.lastBidderRestartTime = this.lastBidderRestartTime;
        target.unknownFields = this.unknownFields;

        return target;
    }

    public StrategyData copy() {
        final StrategyData target = new StrategyData();
        return this.copyTo(target);
    }
    public static Set<ModelProperty> allModelProperties() {
        return ImmutableSet.of(
                NAME,
                AVG_BID,
                AVG_CPA,
                PAY_FOR_CONVERSION,
                AVG_CPI,
                AVG_CPM,
                FILTER_AVG_BID,
                FILTER_AVG_CPA,
                BID,
                SUM,
                BUDGET,
                GOAL_ID,
                CRR,
                ROI_COEF,
                RF_DECAY,
                RF_MIN_CPM,
                PROFITABILITY,
                RESERVE_RETURN,
                LIMIT_CLICKS,
                PLACE,
                START,
                FINISH,
                DATE,
                DAILY_CHANGE_COUNT,
                LAST_BIDDER_RESTART_TIME,
                VERSION
        );
    }
}
