package ru.yandex.direct.core.entity.campaign.model;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public enum StrategyPlace {
    @JsonProperty("highest_place")
    HIGHEST_PLACE("highest_place");

    private static final Map<String, StrategyPlace> ENUMS = Arrays.stream(values())
            .collect(Collectors.toMap(StrategyPlace::getTypedValue, e -> e));

    private final String typedValue;

    StrategyPlace(String typedValue) {
        this.typedValue = typedValue;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public static StrategyPlace fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null) {
            return null;
        }
        StrategyPlace result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
