# -*- coding: utf-8 -*-

from ut_utils import TestModelGeneratorResult, compare_dirs
from yatest.common import source_path


class TestCoreModel(TestModelGeneratorResult):
    conf_dir = source_path("direct/libs-internal/core-base-campaign-model/src/main/resources/model-conf")
    generated_dir = source_path("direct/libs-internal/core-base-campaign-model/src/generated/java")

    @classmethod
    def additional_args(cls):
        return ["--rewrite"]

    def test_model(self):
        result, message = compare_dirs(self.generated_dir, self.tmpdir)
        assert result, message + ", please regenerate models or update .conf files"
