package ru.yandex.direct.core.entity.bidmodifier.model;

import java.util.Objects;

public class BidModifierExpressionLiteral {
    private BidModifierExpressionParameter parameter;

    private BidModifierExpressionOperator operation;

    private Integer valueInteger;
    private String valueString;

    public BidModifierExpressionParameter getParameter() {
        return parameter;
    }

    public void setParameter(BidModifierExpressionParameter parameter) {
        this.parameter = parameter;
    }

    public BidModifierExpressionLiteral withParameter(BidModifierExpressionParameter parameter) {
        this.parameter = parameter;
        return this;
    }

    public BidModifierExpressionOperator getOperation() {
        return operation;
    }

    public void setOperation(BidModifierExpressionOperator operation) {
        this.operation = operation;
    }

    public BidModifierExpressionLiteral withOperation(BidModifierExpressionOperator operation) {
        this.operation = operation;
        return this;
    }

    public Integer getValueInteger() {
        return valueInteger;
    }

    public void setValueInteger(Integer valueInteger) {
        this.valueInteger = valueInteger;
    }

    public BidModifierExpressionLiteral withValueInteger(Integer value) {
        this.valueInteger = value;
        return this;
    }

    public String getValueString() {
        return valueString;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public BidModifierExpressionLiteral withValueString(String value) {
        this.valueString = value;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BidModifierExpressionLiteral that = (BidModifierExpressionLiteral) o;
        return parameter == that.parameter &&
                operation == that.operation &&
                Objects.equals(valueInteger, that.valueInteger) &&
                Objects.equals(valueString, that.valueString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parameter, operation, valueInteger, valueString);
    }
}
