package ru.yandex.direct.core.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Бинарные операторы для условий корректировок.
 * В @JsonProperty указано, как будут выглядеть операторы в JSON
 * Делаем их так же, как и погодные операторы, чтобы можно было потом легко смигрировать погоду в
 * expression-корректировки
 */
public enum BidModifierExpressionOperator {
    /**
     * >
     * Операция применима к числам
     */
    @JsonProperty("gt")
    GT,
    /**
     * <
     * Операция применима к числам
     */
    @JsonProperty("lt")
    LT,
    /**
     * >=
     * Операция применима к числам
     */
    @JsonProperty("ge")
    GE,
    /**
     * <=
     * Операция применима к числам
     */
    @JsonProperty("le")
    LE,
    /**
     * ==
     * Операция применима к числам, строкам и енумам (которые трактуются аналогично строкам)
     */
    @JsonProperty("eq")
    EQ,
    /**
     * !=
     * not equal
     * Операция применима к числам, строкам и енумам (которые трактуются аналогично строкам)
     */
    @JsonProperty("ne")
    NE,
    /**
     * <pre>
     * Операция, похожая на == по семантике, однако БК оперирует именно ей.
     * Применима только к ret_cond_id.
     *
     * Пример выражения для БК:
     * ["goal-context-id", "match goal context", "697645"]
     * </pre>
     */
    @JsonProperty("match_goal_context")
    MATCH_GOAL_CONTEXT,
}
