package ru.yandex.direct.core.entity.bidmodifier.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Названия параметров в выражениях корректировок.
 * Один и тот же параметр теоретически может быть использован в корректировках разных типов.
 * В @JsonProperty указываем ожидаемые названия параметров со стороны БК ("кейворды")
 * (чтобы не делать конвертаций в транспорте).
 */
public enum BidModifierExpressionParameter {
    @JsonProperty("prec_strength")
    PREC_STRENGTH,
    @JsonProperty("cloudness")
    CLOUDNESS,
    @JsonProperty("temp")
    TEMP,
    @JsonProperty("traffic-jam")
    TRAFFIC_JAM,
    @JsonProperty("video-content-duration")
    VIDEO_CONTENT_DURATION,
    //TODO ruslansd синкнуться с кейвордами в БК, когда появятся
    @JsonProperty("prisma_income_grade")
    PRISMA_INCOME_GRADE
}
