# -*- coding: utf-8 -*-

from ut_utils import TestModelGeneratorResult, compare_dirs
from yatest.common import source_path, binary_path


class TestCoreModel(TestModelGeneratorResult):
    @classmethod
    def jar_paths(cls):
        return [binary_path("direct/libs-internal/core-base-campaign-model")]

    @classmethod
    def additional_args(cls):
        return ["--rewrite", "-p", "ru.yandex.direct"]

    conf_dir = source_path("direct/libs-internal/core-mobile-content-campaign-model/src/main/model-conf")
    generated_dir = source_path("direct/libs-internal/core-mobile-content-campaign-model/src/generated/java")

    def test_model(self):
        result, message = compare_dirs(self.generated_dir, self.tmpdir)
        assert result, message + ", please regenerate models or update .conf files"
