package ru.yandex.direct.core.entity.adgroupadditionaltargeting.model;

import java.util.Objects;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс для хранения значений таргетингов (не коллекций)
 */
@ParametersAreNonnullByDefault
public class AdditionalTargetingValue<V> {

    public static <V> AdditionalTargetingValue<V> of(V value) {
        return new AdditionalTargetingValue<V>()
                .withValue(value);
    }

    @JsonProperty("value")
    private V value;

    public V getValue() {
        return value;
    }

    public AdditionalTargetingValue<V> withValue(V value) {
        this.value = value;
        return this;
    }

    public <M> M map(Function<V, M> mapper) {
        return mapper.apply(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdditionalTargetingValue<?> that = (AdditionalTargetingValue<?>) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

}
