package ru.yandex.direct.core.entity.adgroupadditionaltargeting.model;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Перечисление допустимых значений языка интерфейса площадки
 */
public enum InterfaceLang {
    RU("ru"),

    UK("uk"),

    EN("en"),

    BY("by"),

    KZ("kz"),

    TR("tr"),

    TT("tt"),

    UZ("uz");

    private static final Map<String, InterfaceLang> ENUMS = Arrays.stream(values())
            .collect(Collectors.toMap(InterfaceLang::getTypedValue, e -> e));

    private final String typedValue;

    InterfaceLang(String typedValue) {
        this.typedValue = typedValue;
    }

    @JsonValue
    public String getTypedValue() {
        return typedValue;
    }

    public static InterfaceLang fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null) {
            return null;
        }
        InterfaceLang result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
