package ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public class VersionedTargetingHelper {
    private VersionedTargetingHelper() {
    }

    public static Integer versionToInt(String value) {
        Integer[] tokens = StreamEx.of(value.split("[.]")).limit(2).map(Integer::parseInt).toArray(Integer[]::new);
        return 1000 * tokens[0] + Math.min(999, tokens[1]);
    }

    public static String versionToString(Integer value) {
        return String.valueOf(value / 1000) + '.' + value % 1000;
    }
}
