package ru.yandex.direct.core.entity.agencyofflinereport.container;

import java.time.LocalDate;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.agencyofflinereport.model.AgencyOfflineReportKind;

/**
 * Параметры оффлайн-отчета, хранящиеся в самом списке отчетов
 */
public class AgencyOfflineReportArgs {

    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate dateFrom;

    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate dateTo;

    @JsonProperty
    private String agencyLogin;

    @JsonProperty
    private AgencyOfflineReportKind reportKind;

    @JsonProperty
    private Long jobId;

    public AgencyOfflineReportArgs() {
    }

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public String getAgencyLogin() {
        return agencyLogin;
    }

    public AgencyOfflineReportKind getReportKind() {
        return reportKind;
    }

    public Long getJobId() {
        return jobId;
    }

    public AgencyOfflineReportArgs withDateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public AgencyOfflineReportArgs withDateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public AgencyOfflineReportArgs withAgencyLogin(String agencyLogin) {
        this.agencyLogin = agencyLogin;
        return this;
    }

    public AgencyOfflineReportArgs withReportKind(AgencyOfflineReportKind reportKind) {
        this.reportKind = reportKind;
        return this;
    }

    public AgencyOfflineReportArgs withJobId(Long jobId) {
        this.jobId = jobId;
        return this;
    }

    @Override
    public String toString() {
        return "AgencyOfflineReportArgs{" +
                "dateFrom=" + dateFrom +
                ", dateTo=" + dateTo +
                ", agencyLogin='" + agencyLogin + '\'' +
                ", reportKind=" + reportKind +
                ", jobId=" + jobId +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AgencyOfflineReportArgs that = (AgencyOfflineReportArgs) o;
        return Objects.equals(dateFrom, that.dateFrom) &&
                Objects.equals(dateTo, that.dateTo) &&
                Objects.equals(agencyLogin, that.agencyLogin) &&
                reportKind == that.reportKind &&
                Objects.equals(jobId, that.jobId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dateFrom, dateTo, agencyLogin, reportKind, jobId);
    }
}
