package ru.yandex.direct.core.entity.aggregatedstatuses;

import java.util.Set;

/**
 * Модель используется на фронте, отсюда префикс, изменение модели порождает релизную зависимость с dna,
 * и должно быть согласновано с фронтом
 * В случае если в ядре нужен расширенный набор значений данного enum-а необходимо завести еще одну модель и маппер
 *
 * Порядок ВАЖЕН! По порядку значений мы выбираем худший, статус, который приоритетнее
 * см.  {@link ru.yandex.direct.core.aggregatedstatuses.logic.StatusUtils#mergeStatuses(SelfStatus, SelfStatus)}
 *
 * Подробнее о системе статусов см. документацию: https://docs.yandex-team.ru/direct-dev/aggr-statuses/concept.html
 */
public enum GdSelfStatusEnum {
    RUN_OK(70), RUN_PROCESSING(65), RUN_WARN(50),
    PAUSE_OK(60), PAUSE_WARN(40), PAUSE_CRIT(20),
    ON_MODERATION(90),
    STOP_OK(80), STOP_PROCESSING(75), STOP_WARN(30), STOP_CRIT(10),
    DRAFT(100), ARCHIVED(110);

    // Актуальный порядок сортировки: https://st.yandex-team.ru/DIRECT-132298#60194981c8ab671c9b76ff0e
    private final int sortOrderValue;
    GdSelfStatusEnum(int sortOrderValue) {
        this.sortOrderValue = sortOrderValue;
    }

    private static final Set<GdSelfStatusEnum> ALL_OK = Set.of(
            RUN_OK, RUN_PROCESSING, PAUSE_OK, STOP_OK, STOP_PROCESSING, ON_MODERATION, DRAFT, ARCHIVED
    );

    private static final Set<GdSelfStatusEnum> ALL_PROCESSING = Set.of(
            RUN_PROCESSING, STOP_PROCESSING
    );

    private static final Set<GdSelfStatusEnum> ALL_RUN = Set.of(
            RUN_OK, RUN_PROCESSING, RUN_WARN
    );

    private static final Set<GdSelfStatusEnum> ALL_PAUSE = Set.of(
            PAUSE_OK, PAUSE_WARN, PAUSE_CRIT
    );

    private static final Set<GdSelfStatusEnum> ALL_STOP = Set.of(
            STOP_OK, STOP_PROCESSING, STOP_WARN, STOP_CRIT
    );

    /**
     * статусы с которыми все хорошо, т.е. они не требуют внимания пользователя
     * @return Set статусов
     */
    public static Set<GdSelfStatusEnum> allOk() {
        return ALL_OK;
    }

    public static Set<GdSelfStatusEnum> allProcessing() {
        return ALL_PROCESSING;
    }

    public static Set<GdSelfStatusEnum> allRun() {
        return ALL_RUN;
    }

    public static Set<GdSelfStatusEnum> allPause() {
        return ALL_PAUSE;
    }

    public static Set<GdSelfStatusEnum> allStop() {
        return ALL_STOP;
    }

    public int getSortOrderValue() {
        return sortOrderValue;
    }
}
