package ru.yandex.direct.core.entity.aggregatedstatuses;

import java.util.Set;

/**
 * Модель используется на фронте, отсюда префикс, изменение модели порождает релизную зависимость с dna,
 * и должно быть согласновано с фронтом
 * В случае если в ядре нужен расширенный набор значений данного enum-а необходимо завести еще одну модель и маппер
 * Подробнее о системе статусов см. документацию: https://docs.yandex-team.ru/direct-dev/aggr-statuses/concept.html
 */
public enum GdSelfStatusReason /* возможно implements DefectId<Void> */ {
    NOTHING(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated
    DRAFT(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated
    ACTIVE(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated
    REJECTED_ON_MODERATION(GdEntityLevel.ANY, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    ARCHIVED(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated
    OFF_BY_MONITORING(GdEntityLevel.ANY, GdSelfStatusPriority.HIGH, 20), // указанный в объявлении сайт недоступен
    SUSPENDED_BY_USER(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated

    ON_MODERATION(GdEntityLevel.ANY, GdSelfStatusPriority.LOW, 50), // Deprecated

    // Deprecared start
    IMAGE_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    REJECTED_BUT_PREVIOUS_VERSION_SHOWN(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    ON_MODERATION_PREVIOUS_VERSION_SHOWN(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    VCARD_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    HAS_REJECTED_CALLOUTS(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    HAS_REJECTED_SITELINKS(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    DISPLAY_HREF_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    TURBOLANDING_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    // Deprecated end

    RETARGETING_SUSPENDED_BY_USER(GdEntityLevel.RETARGETING, GdSelfStatusPriority.MIDDLE, 10),
    KEYWORD_SUSPENDED_BY_USER(GdEntityLevel.KEYWORD, GdSelfStatusPriority.VERY_HIGH, 10),

    // Ads
    AD_SENT_OR_READY_TO_BS(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 10),
    AD_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.VERY_HIGH, 10),
    AD_SUSPENDED_BY_USER(GdEntityLevel.BANNER, GdSelfStatusPriority.VERY_HIGH, 20),

    AD_IMAGE_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_REJECTED_BUT_PREVIOUS_VERSION_SHOWN(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_ON_MODERATION_PREVIOUS_VERSION_SHOWN(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_VCARD_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_HAS_REJECTED_CALLOUTS(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_HAS_REJECTED_SITELINKS(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_DISPLAY_HREF_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_TURBOLANDING_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_HAS_ASOCIAL_FLAG(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50), //Не показывается по интересам пользователя и условиям подбора аудитории //НЕТУ
    AD_HAS_SOCIAL_ADVERTISING_FLAG(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50), //НЕТУ
    AD_HAS_UNFAMILY_OR_TRAGIC_FLAG(GdEntityLevel.BANNER, GdSelfStatusPriority.HIGH, 20), // Объявление взрослой/трагической тематики, жёлтый
    AD_HAS_UNFAMILY_FLAG(GdEntityLevel.BANNER, GdSelfStatusPriority.HIGH, 20), // Объявление взрослой тематики
    AD_HAS_TRAGIC_FLAG(GdEntityLevel.BANNER, GdSelfStatusPriority.HIGH, 20), // Объявление трагической тематики
    AD_HAS_ASOCIAL_FLAG_PLATFORM_BOTH(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50), // Не показывается по интересам пользователя и условиям подбора аудитории //НЕТУ
    AD_HAS_UNFAMILY_OR_TRAGIC_FLAG_PLATFORM_BOTH(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE, 20), // Объявление взрослой/трагической тематики, есть показы на поиске жёлтый
    AD_LOGO_REJECTED_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_BUTTON_REJECTED_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_MULTICARD_SET_REJECTRED_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),

    // Addition on moderation
    AD_DISPLAY_HREF_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_TURBOLANDING_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_VCARD_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_CALLOUTS_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_SITELINKS_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_IMAGE_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_VIDEO_ADDITION_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_LOGO_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_BUTTON_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    AD_MULTICARD_SET_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),

    // outdoor
    AD_HAS_REJECTED_PLACEMENTS(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),
    AD_HAS_PLACEMENTS_ON_OPERATOR_ACTIVATION(GdEntityLevel.BANNER, GdSelfStatusPriority.VERY_HIGH, 10),
    AD_NO_SUITABLE_PLACEMENTS_SELECTED(GdEntityLevel.BANNER, GdSelfStatusPriority.HIGH, 10),
    AD_HAS_PLACEMENTS_ON_OPERATOR_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.VERY_HIGH, 10),

    // Deprecated outdoor start
    HAS_REJECTED_PLACEMENTS(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    HAS_PLACEMENTS_ON_OPERATOR_ACTIVATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    NO_SUITABLE_PLACEMENTS_SELECTED(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    HAS_PLACEMENTS_ON_OPERATOR_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50),
    // Deprecated outdoor end

    VIDEO_ADDITION_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.LOW, 50), // Deprecated
    AD_VIDEO_ADDITION_REJECTED_ON_MODERATION(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE_MODERATION, 10),

    // Автотаргетинг
    RELEVANCE_MATCH_SUSPENDED_BY_USER(GdEntityLevel.BANNER, GdSelfStatusPriority.MIDDLE, 10), // Показы по автотаргетингу остановлены пользователем

    // Группы
    ADGROUP_ADS_SUSPENDED_BY_USER(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH, 20),
    ADGROUP_SHOW_CONDITIONS_SUSPENDED_BY_USER(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH_MODERATION, 10),
    ADGROUP_HAS_NO_ADS_ELIGIBLE_FOR_SERVING(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH, 20),
    ADGROUP_HAS_NO_SHOW_CONDITIONS_ELIGIBLE_FOR_SERVING(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH, 10),
    ADGROUP_SHOW_CONDITIONS_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.VERY_HIGH, 10),
    ADGROUP_SHOW_CONDITIONS_PARTLY_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    ADGROUP_REJECTED_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH_MODERATION, 10),
    ADGROUP_INCOMPLETE(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), // deprecated
    ADGROUP_SHOW_CONDITIONS_REJECTED_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH_MODERATION, 30), // deprecated модератор отклонил все условия показа //НЕТУ
    //ADGROUP_ALL_SHOW_CONDITIONS_REJECTED_ON_MODERATION(GdSelfStatusPriority.HIGH_MODERATION, 10), //НЕ НУЖНО
    ADGROUP_HAS_SHOW_CONDITIONS_REJECTED_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    ADGROUP_ADS_REJECTED_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH_MODERATION, 30), // deprecated модератор отклонил все объявления
    //ADGROUP_ALL_ADS_REJECTED_ON_MODERATION(GdSelfStatusPriority.HIGH_MODERATION, 10), //НЕ НУЖНО
    ADGROUP_HAS_ADS_REJECTED_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    ADGROUP_SHOW_CONDITIONS_WITH_WARNINGS(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50),  //у всех условий показа есть проблемы //НЕТУ
    ADGROUP_HAS_SHOW_CONDITIONS_WITH_WARNINGS(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), //УБИРАЕМ
    ADGROUP_ADS_WITH_WARNINGS(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), //у всех объявлений есть проблемы //НЕТУ
    ADGROUP_HAS_ADS_WITH_WARNINGS(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), //УБИРАЕМ
    ADGROUP_ADS_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.VERY_HIGH, 10), // Все объявления на модерации
    ADGROUP_HAS_ADS_ON_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), //объявление на модерации
    ADGROUP_HAS_RESTRICTED_GEO(GdEntityLevel.GROUP, GdSelfStatusPriority.MIDDLE_MODERATION, 20),
    ADGROUP_HAS_NO_EFFECTIVE_GEO(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH, 10), //группу нельзя показывать в заданных регионах из-за неподходящего контента //ПЕРЕДЕЛЫВАЕТСЯ
    ADGROUP_RARELY_SERVED(GdEntityLevel.GROUP, GdSelfStatusPriority.LOW, 50), //МАЛО ПОКАЗОВ, ПЕРЕДЕЛАТЬ
    ADGROUP_IS_WAITING_START(GdEntityLevel.GROUP, GdSelfStatusPriority.VERY_HIGH, 20),
    ADGROUP_IS_OVER(GdEntityLevel.GROUP, GdSelfStatusPriority.VERY_HIGH, 20),
    ADGROUP_BL_PROCESSING_WITH_OLD_VERSION_SHOWN(GdEntityLevel.GROUP, GdSelfStatusPriority.MIDDLE_MODERATION, 10), // есть старая версия и банеры из предыдущей генерации (для ДО/Смарт), жёлтый
    ADGROUP_BL_PROCESSING(GdEntityLevel.GROUP, GdSelfStatusPriority.VERY_HIGH, 10), // группу изменили (идет генерация банеров), банеры не показываются (для ДО/Смарт)
    ADGROUP_BL_NOTHING_GENERATED(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH, 10), // ничего не сгенерировалось, банеры не показываются (для ДО/Смарт)
    // ADGROUP_DRAFT_CAN_BE_MODERATED, //НЕТУ, МБ, И НЕ ПОДДЕРЖАНО // для черновиков групп, которые можно отправить на модерацию
    ADGROUP_NEED_DOCUMENTS_FOR_MODERATION(GdEntityLevel.GROUP, GdSelfStatusPriority.HIGH_MODERATION, 10), // для показов нужно загрузить соответствующие документы

    // Кампании
    CAMPAIGN_ACTIVE(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50), // Deprecated
    CAMPAIGN_IS_OVER(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 20), // Показы закончились
    CAMPAIGN_SUSPENDED_BY_USER(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 10), // Кампания остановлена пользователем
    CAMPAIGN_ALL_ADGROUPS_SUSPENDED_BY_USER(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 10), // все группы кампании остановлены пользователем
    CAMPAIGN_ADD_MONEY(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 40),
    CAMPAIGN_ADD_MONEY_TO_WALLET(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 40),
    CAMPAIGN_WAIT_PAYMENT(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 40),
    CAMPAIGN_IS_PAUSED_BY_DAY_BUDGET(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE, 10), // Закончился бюджет на сегодня
    CAMPAIGN_IS_PAUSED_BY_WALLET_DAY_BUDGET(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE, 10), // Закончился бюджет на сегодня
    CAMPAIGN_IS_WAITING_START(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10), // Показы начнутся
    CAMPAIGN_IS_PAUSED_BY_TIMETARGETING(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 10), // Показы начнутся по расписанию
    CAMPAIGN_IS_NOT_RECOVERABLE(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10),
    CAMPAIGN_NO_ACTIVE_BANNERS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 20), //нет готовых к показу объявлений
    CAMPAIGN_HAS_INACTIVE_BANNERS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50), //некоторые группы не работают, УБРАТЬ
    CAMPAIGN_ADGROUPS_WITH_WARNINGS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50), // Убрать при первой возможности
    CAMPAIGN_HAS_ADGROUPS_WITH_WARNINGS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50), //у некоторых групп есть проблемы, УБРАТЬ
    CAMPAIGN_ADGROUPS_PROCESSING(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10), //все группы кампании обрабатываются
    CAMPAIGN_HAS_PROCESSING_ADGROUPS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10), //некоторые группы кампании обрабатываются
    CAMPAIGN_HAS_NO_ADS_ELIGIBLE_FOR_SERVING(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 20), // Нет обяъвлений готовых к показу во всей кампании
    CAMPAIGN_UNARCHIVING_IN_PROGRESS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10),
    CAMPAIGN_ON_MODERATION(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH_MODERATION, 10), // группы кампании находятся на модерации
    CAMPAIGN_PARTLY_ON_MODERATION(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE_MODERATION, 10), //некоторые группы находятся на модерации
    // CAMPAIGN_DRAFT_CAN_BE_MODERATED, // для черновиков кампаний, которые можно отправить на модерацию //НЕТУ, МБ, И НЕ ПОДДЕРЖАНО
    CAMPAIGN_UNITS_EXHAUSTED(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE, 10), //завершена по достижению ограничения, серая
    CPM_PRICE_NOT_APPROVED(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 20), // Остановлено. Бронирование отклонено
    CPM_PRICE_INCORRECT(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50),    // Остановлено. Бронирование подтверждено. //НЕТУ
    CAMPAIGN_BL_PROCESSING_WITH_OLD_VERSION_SHOWN(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50), //все группы кампании обрабатываются, показывается старая версия, НЕТУ
    CAMPAIGN_BL_PROCESSING(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10),
    CAMPAIGN_BL_NOTHING_GENERATED(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 20), // Для групп ничего не сгенерировалось в баннер лэнде
    CAMPAIGN_STRATEGY_PERIOD_HAS_ENDED(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.VERY_HIGH, 10),
    CAMPAIGN_STRATEGY_PERIOD_HAS_ENDED_AUTO_PROLONGATION(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE, 30),
    CPM_PRICE_WAITING_FOR_APPROVE(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.MIDDLE, 30), // Остановлено. Ожидает бронирования, жёлтый
    PAY_FOR_CONVERSION_CAMPAIGN_HAS_LACK_OF_FUNDS(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 50), //недостаточно средств на счету для работы по модели оплаты за конверсии
    PAY_FOR_CONVERSION_CAMPAIGN_HAS_LACK_OF_CONVERSION(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.HIGH, 50), //НЕТУ

    // Промоакции
    PROMO_EXTENSION_REJECTED(GdEntityLevel.ANY, GdSelfStatusPriority.MIDDLE, 10), // промоакция не прошла модерацию, показы объявлений без промоакции

    // Мастер-кампании
    UC_CAMPAIGN_SUBJECTS_REJECTED_ON_MODERATION(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50),
    UC_CAMPAIGN_SUBJECTS_PROCESSING(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50),
    UC_CAMPAIGN_SUBJECTS_BL_NOTHING_GENERATED(GdEntityLevel.CAMPAIGN, GdSelfStatusPriority.LOW, 50);

    private final GdEntityLevel level;
    private final GdSelfStatusPriority priority;
    private final int weight;

    GdSelfStatusReason(GdEntityLevel level, GdSelfStatusPriority priority, int weight) {
        this.level = level;
        this.priority = priority;
        this.weight = weight;
    }

    public GdEntityLevel level() {
        return level;
    }

    public int weight() {
        return weight;
    }

    public GdSelfStatusPriority priority() {
        return priority;
    }

    public static boolean isMeaningless(GdSelfStatusReason reason) { // причина которая не интересна, если есть
        // что-то еще
        return meaninglessReason().contains(reason);
    }

    private static Set<GdSelfStatusReason> meaninglessReason() { // причина которая не интересна, если есть что-то еще
        return Set.of(DRAFT, ACTIVE, ARCHIVED, CAMPAIGN_ACTIVE);
    }
}
