package ru.yandex.direct.core.entity.aggregatedstatuses;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


public class StatusReasonTextMapper {

    private static final Map<GdSelfStatusReason, String> translations = Map.ofEntries(
            Map.entry(GdSelfStatusReason.REJECTED_ON_MODERATION, "кампания отклонена при модерации"),
            Map.entry(GdSelfStatusReason.ARCHIVED, "кампания заархивирована"),
            Map.entry(GdSelfStatusReason.SUSPENDED_BY_USER, "кампания остановлена пользователем"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_SUSPENDED_BY_USER, "кампания остановлена пользователем"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_ALL_ADGROUPS_SUSPENDED_BY_USER, "все группы объявлений остановлены пользователем"),
            Map.entry(GdSelfStatusReason.ON_MODERATION, "кампания на модерации"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_IS_NOT_RECOVERABLE, "кампанию нельзя восстановить"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_ADD_MONEY_TO_WALLET, "на кампании закончились деньги"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_HAS_ADGROUPS_WITH_WARNINGS, "у кампании есть группы с ошибками"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_ADGROUPS_WITH_WARNINGS, "у кампании есть группы с ошибками"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_WAIT_PAYMENT, "кампания ожидает оплаты"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_HAS_NO_ADS_ELIGIBLE_FOR_SERVING, "отсутствуют объявления для показа"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_ADD_MONEY, "не хватает денег"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_HAS_INACTIVE_BANNERS, "у кампании есть неактивные баннеры"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_NO_ACTIVE_BANNERS, "у кампании нет активных баннеров"),
            Map.entry(GdSelfStatusReason.CAMPAIGN_ON_MODERATION, "кампания на модерации"),
            Map.entry(GdSelfStatusReason.CPM_PRICE_WAITING_FOR_APPROVE, "кампания с фиксированным CPM ожидает бронирования"),
            Map.entry(GdSelfStatusReason.CPM_PRICE_INCORRECT, "некорректная кампания с фиксированным CPM"),
            Map.entry(GdSelfStatusReason.PROMO_EXTENSION_REJECTED, "промоакция отклонена"));

    public static String getText(GdSelfStatusReason reason) {
        if (translations.containsKey(reason)) {
            return translations.get(reason);
        }
        return reason.name();
    }

    public static String getText(List<GdSelfStatusReason> reasons) {
        return reasons.stream().map(StatusReasonTextMapper::getText).collect(Collectors.joining(", "));
    }
}
