package ru.yandex.direct.core.entity.aggregatedstatuses.ad;

public enum AdStatesEnum {
    ARCHIVED, // объявление помещено в архив
    SUSPENDED, // объявление остановлено пользователем
    DRAFT,
    REJECTED, // объявление или необходимая для показа часть отклонен на модерации
    MODERATION, // объявление или необходимая для показа часть на модерации
    OBSOLETE, // креатив объявления отклонен на модерации как устаревший (DIRECT-148277)

    DRAFT_ON_MODERATION, // special case для учета на группе
    SUSPENDED_BY_MONITORING, // объявление остановлено урл-мониторингом, используется для баннеров внутренней рекламы

    // PREACCEPTED
    BS_SYNCED, // statusBsSynced = Yes
    ACTIVE_IN_BS, // statusActive = Yes, транспорт в БК ответил Stop=0

    // дополнения - то без чего объявление может быть показано
    HAS_REJECTED_CALLOUTS,
    REJECTED_VCARD,
    HAS_REJECTED_SITELINKS,
    REJECTED_IMAGE, // для ТГО (но не ГО или image_ad)
    REJECTED_DISPLAY_HREF,
    REJECTED_TURBOLANDING,
    CREATIVE_REJECTED,
    PREACCEPTED,
    /*
    Если баннер готов для БК, т.е. по сути удволетворяет условию:
    https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/Export.pm?rev=r8834985#L891-892
     */
    READY_TO_BS,
    HREF_MISSED, // deprecated
    REJECTED_VIDEO_ADDITION,
    REJECTED_LOGO,
    REJECTED_BUTTON,
    REJECTED_MULTICARD_SET,

    // дополнения на модерации
    CALLOUTS_ON_MODERATION,
    VCARD_ON_MODERATION,
    SITELINKS_ON_MODERATION,
    IMAGE_ON_MODERATION,
    DISPLAY_HREF_ON_MODERATION,
    TURBOLANDING_ON_MODERATION,
    VIDEO_ADDITION_ON_MODERATION,
    LOGO_ON_MODERATION,
    BUTTON_ON_MODERATION,
    MULTICARD_SET_ON_MODERATION,

    // Флаги
    HAS_ASOCIAL_FLAG,
    HAS_SOCIAL_ADVERTISING_FLAG,
    HAS_UNFAMILY_FLAG,
    HAS_TRAGIC_FLAG,
    HAS_UNFAMILY_OR_TRAGIC_FLAG,

    // Placementes
    HAS_ACCEPTED_PLACEMENTS, HAS_REJECTED_PLACEMENTS,
    HAS_PLACEMENTS_ON_MODERATION, ALL_PLACEMENTS_REJECTED,
    PLACEMENTS_REQUIRED, HAS_PLACEMENTS_ON_OPERATOR_ACTIVATION
}
