package ru.yandex.direct.core.entity.aggregatedstatuses.ad;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.aggregatedstatuses.AggregatedStatusBaseData;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AggregatedStatusAdData extends AggregatedStatusBaseData<AdStatesEnum> {
    @JsonCreator
    public AggregatedStatusAdData(@JsonProperty(STATES) Collection<AdStatesEnum> states,
                                  @JsonProperty(STATUS) GdSelfStatusEnum status,
                                  @JsonProperty(REASONS) List<GdSelfStatusReason> reasons,
                                  @JsonProperty(REJECT_REASONS) Map<ModerationDiagType, Set<Long>> rejectReasons) {
        super(states, status, reasons, rejectReasons);
    }

    public AggregatedStatusAdData(Collection<AdStatesEnum> states,
                                  GdSelfStatusEnum status,
                                  List<GdSelfStatusReason> reasons) {
        super(states, status, reasons);
    }

    public AggregatedStatusAdData(Collection<AdStatesEnum> states,
                                  GdSelfStatusEnum status,
                                  GdSelfStatusReason reason) {
        super(states, status, reason);
    }

    public AggregatedStatusAdData(Collection<AdStatesEnum> states,
                                  SelfStatus status) {
        super(states, status);
    }

    public AggregatedStatusAdData(Collection<AdStatesEnum> states,
                                  GdSelfStatusEnum status) {
        super(states, status);
    }

    public AggregatedStatusAdData withIsObsolete(Boolean isObsolete) {
        setIsObsolete(isObsolete);
        return this;
    }

    public AggregatedStatusAdData withPlatform(CampaignsPlatform platform) {
        setPlatform(platform);
        return this;
    }
}
