package ru.yandex.direct.core.entity.aggregatedstatuses.adgroup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.aggregatedstatuses.AggregatedStatusBaseData;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AggregatedStatusAdGroupData extends AggregatedStatusBaseData<AdGroupStatesEnum> {
    private AdGroupCounters counters;

    @JsonCreator
    public AggregatedStatusAdGroupData(@JsonProperty(STATES) List<AdGroupStatesEnum> states,
                                       @JsonProperty(COUNTERS) AdGroupCounters counters,
                                       @JsonProperty(STATUS) GdSelfStatusEnum status,
                                       @JsonProperty(REASONS) List<GdSelfStatusReason> reasons,
                                       @JsonProperty(REJECT_REASONS) Map<ModerationDiagType, Set<Long>> rejectReasons) {
        super(states, status, reasons, rejectReasons);
        this.counters = nvl(counters, new AdGroupCounters());
    }

    public AggregatedStatusAdGroupData(List<AdGroupStatesEnum> states,
                                       AdGroupCounters counters,
                                       GdSelfStatusEnum status,
                                       List<GdSelfStatusReason> reasons) {
        super(states, status, reasons);
        this.counters = nvl(counters, new AdGroupCounters());
    }

    public AggregatedStatusAdGroupData(List<AdGroupStatesEnum> states,
                                       AdGroupCounters counters,
                                       GdSelfStatusEnum status,
                                       GdSelfStatusReason reason) {
        super(states, status, reason);
        this.counters = nvl(counters, new AdGroupCounters());
    }

    public AggregatedStatusAdGroupData(Collection<AdGroupStatesEnum> states,
                                       AdGroupCounters counters,
                                       SelfStatus status) {
        super(states, status);
        this.counters = counters;
    }

    public AggregatedStatusAdGroupData(GdSelfStatusEnum status) {
        super(List.of(), status);
        this.counters = new AdGroupCounters();
    }

    public AggregatedStatusAdGroupData(GdSelfStatusEnum status, GdSelfStatusReason reason) {
        super(List.of(), status, reason);
        this.counters = new AdGroupCounters();
    }

    public AggregatedStatusAdGroupData(GdSelfStatusEnum status, List<GdSelfStatusReason> reasons) {
        super(List.of(), status, reasons);
        this.counters = new AdGroupCounters();
    }

    /**
     * обнуляет счетчики, когда они пустые или объект в таком статусе, в котором статусы подобъектов нам не интересны
     */
    public void flushCounters() {
        this.counters = null;
    }

    @JsonGetter(COUNTERS)
    public AdGroupCounters getCounters() {
        return counters;
    }

    public AggregatedStatusAdGroupData withIsObsolete(Boolean isObsolete) {
        setIsObsolete(isObsolete);
        return this;
    }

}
