package ru.yandex.direct.core.entity.aggregatedstatuses.campaign;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CampaignCounters {
    @JsonProperty("s")
    private final Map<GdSelfStatusEnum, Integer> statuses;
    @JsonProperty("sts")
    private final Map<AdGroupStatesEnum, Integer> states;
    @JsonProperty("grps")
    private int adgroupsTotal;
    // какие-то кастомные счетчики можно добавить отдельным полем

    public CampaignCounters(int adgroupsTotal, Map<GdSelfStatusEnum, Integer> statuses, Map<AdGroupStatesEnum, Integer> states) {
        this.statuses = nvl(statuses, new EnumMap<>(GdSelfStatusEnum.class));
        this.states = nvl(states, new EnumMap<>(AdGroupStatesEnum.class));
        this.adgroupsTotal = adgroupsTotal;
    }

    public CampaignCounters() {
        adgroupsTotal = 0;
        statuses = new EnumMap<>(GdSelfStatusEnum.class);
        states = new EnumMap<>(AdGroupStatesEnum.class);
    }


    @JsonGetter("s")
    public Map<GdSelfStatusEnum, Integer> getStatusesUnsafe() {
        return nullIfEmpty(statuses);
    }

    @JsonGetter("sts")
    public Map<AdGroupStatesEnum, Integer> getStatesUnsafe() {
        return nullIfEmpty(states);
    }

    @JsonIgnore
    public Map<GdSelfStatusEnum, Integer> getStatuses() {
        return statuses;
    }

    @JsonIgnore
    public Map<AdGroupStatesEnum, Integer> getStates() {
        return states;
    }

    public int getAdgroupsTotal() {
        return adgroupsTotal;
    }

    public void incr(AdGroupStatesEnum state) {
        states.compute(state, (s, c) -> c == null ? 1 : c + 1);
    }

    public void incr(Collection<AdGroupStatesEnum> states) {
        for (AdGroupStatesEnum state : states) {
            incr(state);
        }
    }

    public void incr(GdSelfStatusEnum status) {
        statuses.compute(status, (s, c) -> c == null ? 1 : c + 1);
    }

    public void incrAdgroupsCount() {
        adgroupsTotal = adgroupsTotal + 1;
    }

    private <T extends Map> T nullIfEmpty(T map) {
        return map.isEmpty() ? null : map;
    }
}
