package ru.yandex.direct.core.entity.aggregatedstatuses.keyword;

import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.AggregatedStatusBaseData;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public class AggregatedStatusKeywordData extends AggregatedStatusBaseData<KeywordStatesEnum> {
    public AggregatedStatusKeywordData(GdSelfStatusEnum status, GdSelfStatusReason reason) {
        super(Collections.emptyList(), status, reason);
    }

    public AggregatedStatusKeywordData(GdSelfStatusEnum status) {
        super(Collections.emptyList(), status);
    }

    public AggregatedStatusKeywordData(SelfStatus status) {
        super(Collections.emptyList(), status);
    }

    public AggregatedStatusKeywordData withIsObsolete(Boolean isObsolete) {
        setIsObsolete(isObsolete);
        return this;
    }

}
