package ru.yandex.direct.core.entity.aggregatedstatuses.retargeting;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.aggregatedstatuses.AggregatedStatusBaseData;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AggregatedStatusRetargetingData extends AggregatedStatusBaseData<RetargetingStatesEnum> {
    @JsonCreator
    public AggregatedStatusRetargetingData(@JsonProperty(STATES) Collection<RetargetingStatesEnum> states,
                                           @JsonProperty(STATUS) GdSelfStatusEnum status,
                                           @JsonProperty(REASONS) List<GdSelfStatusReason> reasons) {
        super(states, status, reasons);
    }

    public AggregatedStatusRetargetingData(Collection<RetargetingStatesEnum> states,
                                           GdSelfStatusEnum status,
                                           GdSelfStatusReason reason) {
        super(states, status, reason);
    }

    public AggregatedStatusRetargetingData(Collection<RetargetingStatesEnum> states,
                                           SelfStatus status) {
        super(states, status);
    }

    public AggregatedStatusRetargetingData(GdSelfStatusEnum status) {
        super(List.of(), status);
    }

    public AggregatedStatusRetargetingData(GdSelfStatusEnum status, GdSelfStatusReason reason) {
        super(List.of(), status, reason);
    }

    public AggregatedStatusRetargetingData withIsObsolete(Boolean isObsolete) {
        setIsObsolete(isObsolete);
        return this;
    }

}
