package ru.yandex.direct.core.entity.banner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum Age implements FlagWithValue {
    AGE_0("0"),
    AGE_6("6"),
    AGE_12("12"),
    AGE_16("16"),
    AGE_18("18");

    private final String value;

    // дополнительное значение в ENUMS для AGE_18 для обратной конвертации из БД в enum обоих возможных вариантов
    private static final Map<String, Age> ENUMS = enumToInvertMap();

    private static Map<String, Age> enumToInvertMap() {
        Map<String, Age> enumInvertMap = Arrays.stream(Age.values())
                .collect(Collectors.toMap(Age::getValue, e -> e));
        enumInvertMap.put("plus18", AGE_18);

        // Значение флага ageX - это алиас для значения X (https://st.yandex-team.ru/DIRECT-112471)
        enumInvertMap.put("age0", AGE_0);
        enumInvertMap.put("age6", AGE_6);
        enumInvertMap.put("age12", AGE_12);
        enumInvertMap.put("age16", AGE_16);
        enumInvertMap.put("age18", AGE_18);

        return Collections.unmodifiableMap(enumInvertMap);
    }

    Age(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }


    public static Age fromSource(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }

        Age age = ENUMS.get(value);
        if (age == null) {
            throw new IllegalArgumentException("Unknown age flag value " + value);
        }

        return age;
    }

}
