package ru.yandex.direct.core.entity.banner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

public enum BabyFood implements FlagWithValue {
    BABY_FOOD_0("0"),
    BABY_FOOD_1("1"),
    BABY_FOOD_2("2"),
    BABY_FOOD_3("3"),
    BABY_FOOD_4("4"),
    BABY_FOOD_5("5"),
    BABY_FOOD_6("6"),
    BABY_FOOD_7("7"),
    BABY_FOOD_8("8"),
    BABY_FOOD_9("9"),
    BABY_FOOD_10("10"),
    BABY_FOOD_11("11"),
    BABY_FOOD_12("12");

    private static final Map<String, BabyFood> ENUMS = enumToInvertMap();

    private static Map<String, BabyFood> enumToInvertMap() {
        Map<String, BabyFood> enumInvertMap = Arrays.stream(BabyFood.values())
                .collect(Collectors.toMap(BabyFood::getTypedValue, e -> e));

        // Значение флага baby_foodX - это алиас для значения X (https://st.yandex-team.ru/DIRECT-121098)
        enumInvertMap.put("baby_food0", BABY_FOOD_0);
        enumInvertMap.put("baby_food1", BABY_FOOD_1);
        enumInvertMap.put("baby_food2", BABY_FOOD_2);
        enumInvertMap.put("baby_food3", BABY_FOOD_3);
        enumInvertMap.put("baby_food4", BABY_FOOD_4);
        enumInvertMap.put("baby_food5", BABY_FOOD_5);
        enumInvertMap.put("baby_food6", BABY_FOOD_6);
        enumInvertMap.put("baby_food7", BABY_FOOD_7);
        enumInvertMap.put("baby_food8", BABY_FOOD_8);
        enumInvertMap.put("baby_food9", BABY_FOOD_9);
        enumInvertMap.put("baby_food10", BABY_FOOD_10);
        enumInvertMap.put("baby_food11", BABY_FOOD_11);
        enumInvertMap.put("baby_food12", BABY_FOOD_12);

        return Collections.unmodifiableMap(enumInvertMap);
    }

    private final String typedValue;

    BabyFood(String typedValue) {
        this.typedValue = typedValue;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public static BabyFood fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null || typedValue.isEmpty()) {
            return null;
        }

        BabyFood babyFood = ENUMS.get(typedValue);
        if (babyFood == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }

        return babyFood;
    }

    @Override
    public String getValue() {
        return typedValue;
    }
}
