package ru.yandex.direct.core.entity.banner.model;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum BannerGeoLegalFlags implements FlagWithValue {
    ACIDS("acids"),
    ALCOHOL("alcohol"),
    BANKS("banks"),
    BINARY_OPTIONS("binary_options"),
    CREDIT_CONSUMER_COOPERATIVE("credit_consumer_cooperative"),
    DETECTIVE("detective"),
    DIETARYSUPPL("dietarysuppl"),
    EXPLOSIONS("explosions"),
    FOREX("forex"),
    FOREX_BROKER("forex_broker"),
    GAMBLE("gamble"),
    INSURANCE("insurance"),
    LOAN("loan"),
    MATERNITY_CAPITAL("maternity_capital"),
    MED_EQUIPMENT("med_equipment"),
    MED_SERVICES("med_services"),
    MFI("mfi"),
    NOT_MEDICINE("not_medicine"),
    OPTICS("optics"),
    PAWNSHOP("pawnshop"),
    PAYMENT("payment"),
    PHARMACY("pharmacy"),
    POPULAR_MEDICINE("popular_medicine"),
    PSEUDOWEAPON("pseudoweapon"),
    PSYCHOLOGY("psychology"),
    SPORTS_NUTRITION("sports_nutrition"),
    TECH_INSPECTION("tech_inspection"),
    TOBACCO("tobacco"),
    TRANSPORT("transport"),
    VETERINARY("veterinary"),
    ABORTION("abortion"),
    CAR_NUMBERS("car_numbers"),
    ILLEGAL_DIET("illegal_diet"),
    DRUGS("drugs"),
    BOOKMAKER("bookmaker"),
    DETECTIVE_EQUIPMENT("detective_equipment"),
    JEWELRY("jewelry"),
    MEDIATION("mediation"),
    NOTARY("notary"),
    REALTOR("realtor"),
    WEAPONS("weapons"),
    MAGIC("magic"),
    TATTOO("tattoo"),
    CHARITY("charity"),
    LOTTERY("lottery"),
    TELEMED("telemed"),
    ELECTRONIC_OSAGO("electronic_osago"),
    WORK_ABROAD("work_abroad"),
    FOREIGN_TRADE("foreign_trade"),
    AD_ON_TRANSPORT("ad_on_transport"),
    CRYPTOCURRENCY("cryptocurrency"),
    ILLEGAL("illegal"),
    COLLECTOR("collector"),
    MILK_SUBSTITUTE("milk_substitute"),
    CERTIFICATION("certification"),
    DIPLOMA("diploma"),
    LEGAL_VAPE("legal_vape"),
    EDUCATION("education"),
    PEOPLE("people"),
    SOCIAL_ADVERTISING("social_advertising"),
    PROJECT_DECLARATION("project_declaration");

    private final String value;

    BannerGeoLegalFlags(String value) {
        this.value = value;
    }

    public static BannerGeoLegalFlags fromValue(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }

        BannerGeoLegalFlags bannerGeoLegalFlag = BannerGeoLegalFlags.valueOf(value);
        if (bannerGeoLegalFlag == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + value);
        }

        return bannerGeoLegalFlag;
    }

    public static final Set<String> VALUES =
            Arrays.stream(BannerGeoLegalFlags.values()).map(e -> e.getValue()).collect(Collectors.toUnmodifiableSet());

    @Override
    public String getValue() {
        return value;
    }
}
