package ru.yandex.direct.core.entity.banner.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.model.Relationship;

@ParametersAreNonnullByDefault
public class BannerLinkedToBannerImageFormat implements Relationship<BannerImageFormat, BannerWithAdGroupId, String> {
    @Override
    public String getParentId(BannerWithAdGroupId child) {
        if (child instanceof BannerWithBannerImage) {
            var banner = (BannerWithBannerImage) child;
            return banner.getImageHash();
        } else if (child instanceof BannerWithImage) {
            var banner = (BannerWithImage) child;
            return banner.getImageHash();
        } else {
            return null;
        }
    }

    @Override
    public void setParentId(BannerWithAdGroupId child, String imageHash) {
        if (child instanceof BannerWithBannerImage) {
            var banner = (BannerWithBannerImage) child;
            banner.setImageHash(imageHash);
        } else if (child instanceof BannerWithImage) {
            var banner = (BannerWithImage) child;
            banner.setImageHash(imageHash);
        }
    }

    @Override
    public Class getParentEntityClass() {
        return BannerImageFormat.class;
    }

    @Override
    public Class getChildEntityClass() {
        return BannerWithAdGroupId.class;
    }
}
