package ru.yandex.direct.core.entity.banner.model;


import ru.yandex.direct.dbschema.ppc.enums.BannerMulticardsCurrency;

/**
 * Список валют для мультибаннера
 * <p>
 * При добавлении валюты нужно не забыть перегенерировать модели (собираются по данному Enum-у):
 * модель ru.yandex.direct.grid.processing.model.banner.mutation.GdAddMulticard
 * модель ru.yandex.direct.grid.processing.model.banner.mutation.GdUpdateMulticard
 * модель ru.yandex.direct.grid.processing.model.banner.GdMulticard
 */
public enum BannerMulticardsCurrencyValues {
    RUB,

    UAH,

    BYN,

    USD,

    EUR,

    KZT,

    TRY,

    CHF,

    UZS;

    public static BannerMulticardsCurrency toSource(BannerMulticardsCurrencyValues currency) {
        return BannerMulticardsCurrency.valueOf(currency.name());
    }
}
