package ru.yandex.direct.core.entity.banner.model;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

import static ru.yandex.direct.core.entity.banner.model.ButtonAction.ButtonActionTranslations.INSTANCE;


/**
 * Список действий по кнопке
 * <p>
 * При добавлении действия нужно не забыть перегенерировать
 * модель ru.yandex.direct.grid.processing.model.banner.GdButtonAction (собирается по данному Enum-у).
 * Также нужно отключить показ новых действий на фронте, пока не появятся переводы
 */
public enum ButtonAction {
    GO_TO_WEBSITE(INSTANCE.goToWebsite()),
    MORE(INSTANCE.more()),
    GET_PRICE(INSTANCE.getPrice()),
    GET_OFFER(INSTANCE.getOffer()),
    APPLY(INSTANCE.apply()),
    BOOK(INSTANCE.book()),
    REGISTER(INSTANCE.register()),
    SUBSCRIBE(INSTANCE.subscribe()),
    CHOOSE(INSTANCE.choose()),
    TRY(INSTANCE.tryItem()),
    WATCH(INSTANCE.watch()),
    TURN_ON(INSTANCE.turnOn()),
    LISTEN(INSTANCE.listen()),
    PLAY(INSTANCE.play()),
    START(INSTANCE.start()),
    BUY(INSTANCE.buy()),
    DOWNLOAD(INSTANCE.download()),
    INSTALL(INSTANCE.install()),
    ARROW(INSTANCE.arrow()),
    CUSTOM_TEXT(INSTANCE.customText());

    private final Translatable description;

    ButtonAction(Translatable description) {
        this.description = description;
    }

    public Translatable getDescription() {
        return description;
    }

    // Читаем из базы в любом регистре
    public static ButtonAction fromSource(String name) {
        return name == null ? null : ButtonAction.valueOf(name.toUpperCase());
    }

    // Сохраняем в базу в нижнем регистре
    public static String toSource(ButtonAction buttonAction) {
        return buttonAction.name().toLowerCase();
    }

    public interface ButtonActionTranslations extends TranslationBundle {
        ButtonActionTranslations INSTANCE = I18NBundle.implement(ButtonActionTranslations.class);

        @TranslationStub("Перейти на сайт")
        Translatable goToWebsite();

        @TranslationStub("Узнать больше")
        Translatable more();

        @TranslationStub("Узнать цену")
        Translatable getPrice();

        @TranslationStub("Получить предложение")
        Translatable getOffer();

        @TranslationStub("Подать заявку")
        Translatable apply();

        @TranslationStub("Забронировать")
        Translatable book();

        @TranslationStub("Зарегистрироваться")
        Translatable register();

        @TranslationStub("Подписаться")
        Translatable subscribe();

        @TranslationStub("Выбрать")
        Translatable choose();

        @TranslationStub("Попробовать")
        Translatable tryItem();

        @TranslationStub("Смотреть")
        Translatable watch();

        @TranslationStub("Включить")
        Translatable turnOn();

        @TranslationStub("Слушать")
        Translatable listen();

        @TranslationStub("Играть")
        Translatable play();

        @TranslationStub("Начать")
        Translatable start();

        @TranslationStub("Купить")
        Translatable buy();

        @TranslationStub("Скачать")
        Translatable download();

        @TranslationStub("Установить")
        Translatable install();

        @TranslationStub("Стрелка")
        Translatable arrow();

        @TranslationStub("Произвольный текст")
        Translatable customText();
    }
}
