package ru.yandex.direct.core.entity.bids.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BidSelectionCriteriaSimple implements BidSelectionCriteria {
    private final Long id;
    private final Long campaignId;
    private final Long adGroupId;

    private BidSelectionCriteriaSimple(@Nullable Long id, @Nullable Long campaignId, @Nullable Long adGroupId) {
        this.id = id;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
    }

    public static BidSelectionCriteriaSimple fromCampaignId(Long campaignId) {
        return new BidSelectionCriteriaSimple(null, campaignId, null);
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public Long getCampaignId() {
        return campaignId;
    }

    @Override
    public Long getAdGroupId() {
        return adGroupId;
    }
}
