package ru.yandex.direct.core.entity.bids.container;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.keyword.model.ServingStatus;
import ru.yandex.direct.model.Model;

import static java.util.Arrays.asList;
import static java.util.Collections.emptySet;

public class ShowConditionSelectionCriteria implements Model {
    private Collection<AdGroupType> adGroupTypes = new ArrayList<>();
    private Collection<Long> showConditionIds = new ArrayList<>();
    private Collection<Long> adGroupIds = new ArrayList<>();
    private Collection<Long> campaignIds = new ArrayList<>();
    private Set<ServingStatus> servingStatuses;
    private Set<ShowConditionStateSelection> states;
    private Set<ShowConditionStatusSelection> statuses;
    private LocalDateTime modifiedSince;

    public static ShowConditionSelectionCriteria fromShowConditionList(
            List<? extends BidSelectionCriteria> setBidItemList) {
        ShowConditionSelectionCriteria criteria = new ShowConditionSelectionCriteria();
        for (BidSelectionCriteria setBidItem : setBidItemList) {
            if (setBidItem.getId() != null) {
                criteria.addShowConditionIds(setBidItem.getId());
            }
            if (setBidItem.getAdGroupId() != null) {
                criteria.addAdGroupIds(setBidItem.getAdGroupId());
            }
            if (setBidItem.getCampaignId() != null) {
                criteria.addCampaignIds(setBidItem.getCampaignId());
            }
        }
        return criteria;
    }

    public Collection<Long> getShowConditionIds() {
        return showConditionIds;
    }

    public ShowConditionSelectionCriteria withShowConditionIds(Collection<Long> showConditionIds) {
        this.showConditionIds = showConditionIds;
        return this;
    }

    public ShowConditionSelectionCriteria addShowConditionIds(Long... showConditionIds) {
        this.showConditionIds.addAll(asList(showConditionIds));
        return this;
    }

    public Collection<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public ShowConditionSelectionCriteria withAdGroupIds(Collection<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public ShowConditionSelectionCriteria addAdGroupIds(Long... adGroupIds) {
        this.adGroupIds.addAll(asList(adGroupIds));
        return this;
    }

    public Collection<Long> getCampaignIds() {
        return campaignIds;
    }

    public ShowConditionSelectionCriteria withCampaignIds(Collection<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public ShowConditionSelectionCriteria addCampaignIds(Long... campaignIds) {
        this.campaignIds.addAll(asList(campaignIds));
        return this;
    }

    public Set<ShowConditionStateSelection> getStates() {
        return states == null ? emptySet() : states;
    }

    public ShowConditionSelectionCriteria withStates(Set<ShowConditionStateSelection> states) {
        this.states = states;
        return this;
    }

    public ShowConditionSelectionCriteria withStates(ShowConditionStateSelection... states) {
        withStates(new HashSet<>(asList(states)));
        return this;
    }

    public Set<ShowConditionStatusSelection> getStatuses() {
        return statuses == null ? emptySet() : statuses;
    }

    public ShowConditionSelectionCriteria withStatuses(Set<ShowConditionStatusSelection> statuses) {
        this.statuses = statuses;
        return this;
    }

    public ShowConditionSelectionCriteria withStatuses(ShowConditionStatusSelection... statuses) {
        withStatuses(new HashSet<>(asList(statuses)));
        return this;
    }

    public LocalDateTime getModifiedSince() {
        return modifiedSince;
    }

    public ShowConditionSelectionCriteria withModifiedSince(LocalDateTime modifiedSince) {
        this.modifiedSince = modifiedSince;
        return this;
    }

    public Set<ServingStatus> getServingStatuses() {
        return servingStatuses == null ? emptySet() : servingStatuses;
    }

    public ShowConditionSelectionCriteria withServingStatuses(
            Set<ServingStatus> servingStatuses) {
        this.servingStatuses = servingStatuses;
        return this;
    }

    public Collection<AdGroupType> getAdGroupTypes() {
        return adGroupTypes;
    }

    public ShowConditionSelectionCriteria withAdGroupTypes(Collection<AdGroupType> adGroupTypes) {
        this.adGroupTypes = adGroupTypes;
        return this;
    }
}
