package ru.yandex.direct.core.entity.bids.container;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.bids.model.Bid;
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseBidType;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Arrays.asList;
import static ru.yandex.direct.core.entity.bids.model.Bid.AUTOBUDGET_PRIORITY;
import static ru.yandex.direct.core.entity.bids.model.Bid.PRICE;
import static ru.yandex.direct.core.entity.bids.model.Bid.PRICE_CONTEXT;

public enum ShowConditionType {
    AUDIENCE_TARGET(asList(PRICE_CONTEXT, AUTOBUDGET_PRIORITY)),
    RELEVANCE_MATCH(asList(PRICE, PRICE_CONTEXT, AUTOBUDGET_PRIORITY)),
    OFFERING_RETARGETING(asList(PRICE, PRICE_CONTEXT, AUTOBUDGET_PRIORITY)),
    KEYWORD(asList(PRICE, PRICE_CONTEXT, AUTOBUDGET_PRIORITY));

    private final List<ModelProperty<?, ?>> availableBidTypes;

    ShowConditionType(List<ModelProperty<?, ?>> availableBidTypes) {
        this.availableBidTypes = availableBidTypes;
    }

    @Nullable
    public static ShowConditionType fromBidsBaseBidType(BidsBaseBidType value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case keyword:
                return KEYWORD;
            case relevance_match_search:
                return RELEVANCE_MATCH;
            case relevance_match:
                return RELEVANCE_MATCH;
            case offer_retargeting:
                return OFFERING_RETARGETING;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static BidsBaseBidType toBidsBaseBidType(ShowConditionType value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case KEYWORD:
                return BidsBaseBidType.keyword;
            case RELEVANCE_MATCH:
                return BidsBaseBidType.relevance_match;
            case OFFERING_RETARGETING:
                return BidsBaseBidType.offer_retargeting;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    public List<ModelProperty<?, ?>> getAvailableBidTypes() {
        return availableBidTypes;
    }

    public boolean shouldCheckBidValueFor(ModelProperty<? super Bid, ?> modelProperty) {
        return availableBidTypes.contains(modelProperty);
    }
}
