package ru.yandex.direct.core.entity.crypta;

import java.util.Arrays;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;

public enum AudienceType {
    GENDER(2499000021L, false),

    AGE(2499000022L, false),

    INCOME(2499000023L, false),

    MARITAL_STATUS(2499000100L, false),

    CHILDREN(2499000110L, true),
    LIFE_EVENTS(2499000118L, true),

    OCCUPATION(2499000120L, true),

    TELEVISION(2499000200L, false),
    INTERNET(2499000220L, true),
    DEVICES(2499000240L, true),
    TRANSPORTATION(2499000260L, true),
    VISITED(2499000265L, true),
    IN_STORE_PURCHASES(2499000318L, true),
    TRAVEL(2499000355L, true);

    private static final ImmutableMap<Long, AudienceType> ENUMS = ImmutableMap.copyOf(
            Arrays.stream(values())
                    .collect(Collectors.toMap(AudienceType::getTypedValue, e -> e)));

    private final Long typedValue;

    /**
     * Некоторые коллекции целей крипты не должны содержать все значения с одинаковым parentId.
     * Например, мужской и женский пол.
     * Так как это сужает возможную аудиторию из-за наличия неразмеченных людей.
     */
    private final boolean allValuesAllowed;

    AudienceType(Long typedValue, boolean allValuesAllowed) {
        this.typedValue = typedValue;
        this.allValuesAllowed = allValuesAllowed;
    }

    public Long getTypedValue() {
        return typedValue;
    }

    public boolean isAllValuesAllowed() {
        return allValuesAllowed;
    }

    public static AudienceType fromTypedValue(@Nullable Long typedValue) {
        if (typedValue == null) {
            return null;
        }
        AudienceType result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
