package ru.yandex.direct.core.entity.feed.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import java.time.LocalDateTime

@JsonIgnoreProperties(ignoreUnknown = true)
data class FeedOfferExamples(
    @JsonProperty("data_params") val offers: Map<String, Offer>?
) {
    @JsonIgnoreProperties(ignoreUnknown = true)
    data class Offer(
        @JsonProperty("target_url") val targetUrl: String,
        @JsonProperty("price") val price: Price,
        @JsonProperty("text") val text: Text,
        @JsonProperty("click_url") val clickUrls: ClickUrls,
        @JsonProperty("image") val image: ImageInfo,

        @JsonProperty("update_date")
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
        var updateDate: LocalDateTime?
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class Price(
        @JsonProperty("current") val current: String,
        @JsonProperty("old") val old: String?
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class Text(
        @JsonProperty("description_for_direct") val descriptionForDirect: String?,
        @JsonProperty("params_for_direct") val paramsForDirect: String?,
        @JsonProperty("name") val name: String,
        @JsonProperty("currency_iso_code") val currencyIsoCode: String
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class ClickUrls(
        @JsonProperty("text_name") val textName: String,
        @JsonProperty("text_body") val textBody: String?,
        @JsonProperty("price_current") val priceCurrent: String?,
        @JsonProperty("price_old") val priceOld: String?,
        @JsonProperty("image_small") val imageSmall: String?,
        @JsonProperty("image_orig") val imageOrig: String?,
        @JsonProperty("image_big") val imageBig: String?,
        @JsonProperty("image_huge") val imageHuge: String?
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class ImageInfo(
        @JsonProperty("small") val small: Image,
        @JsonProperty("orig") val orig: Image,
        @JsonProperty("big") val big: Image,
        @JsonProperty("huge") val huge: Image
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class Image(
        @JsonProperty("width") val width: Int,
        @JsonProperty("height") val height: Int,
        @JsonProperty("url") val url: String,
        @JsonProperty("smart-centers") val smartCenters: Map<String, SmartCenter>?
    )

    @JsonIgnoreProperties(ignoreUnknown = true)
    data class SmartCenter(
        @JsonProperty("x") val x: Int,
        @JsonProperty("y") val y: Int,
        @JsonProperty("w") val w: Int,
        @JsonProperty("h") val h: Int
    )
}
