package ru.yandex.direct.core.entity.freelancer.model;

/**
 * Значения связаны со значениями в БД и на фронте!
 * При необходимости их изменить требуется согласование с фронтом.
 */
public enum FreelancerSkillOfferDuration {
    FROM_1_TO_3_DAYS,
    FROM_3_TO_7_DAYS,
    FROM_7_TO_14_DAYS,
    FROM_14_TO_28_DAYS,
    FROM_1_TO_3_MONTHS,
    MORE_THAN_3_MONTHS,
    MONTHLY,
    NOT_DEFINED;

    public static FreelancerSkillOfferDuration fromDb(String duration) {
        try {
            return FreelancerSkillOfferDuration.valueOf(duration.toUpperCase());
        } catch (IllegalArgumentException e) {
            return FreelancerSkillOfferDuration.NOT_DEFINED;
        }
    }

    public static String toDb(FreelancerSkillOfferDuration duration) {
        return duration.toString().toLowerCase();
    }
}
