package ru.yandex.direct.core.entity.freelancer.model;


/**
 * Причина отклонения карточки фрилансера.
 */
public enum FreelancersCardDeclineReason {
    /**
     * Не соблюдены требования к фотографии.
     */
    BAD_IMAGE("bad_image", "bad_image"),
    /**
     * Не соблюдены требования к тексту.
     */
    BAD_DESCRIPTION("bad_description", "bad_description"),
    /**
     * Не соблюдены требования к сайту.
     */
    BAD_HREF("bad_href", "bad_href");

    /**
     * Код причины отклонения на стороне базы данных.
     */
    private final String dbName;
    /**
     * Код причины отклонения на стороне модерации.
     * О кодах договаривались здесь: https://st.yandex-team.ru/MODADVERT-1019#1536654264000
     */
    private final String moderationName;

    FreelancersCardDeclineReason(String dbName, String moderationName) {
        this.dbName = dbName;
        this.moderationName = moderationName;
    }

    public String getModerationName() {
        return moderationName;
    }

    public String getDbName() {
        return dbName;
    }
}
